//
//  CommonDefinitions.h
//  BasicVascularModeling
//
//  Created by Artur Klepaczko on 27.05.2014.
//  Copyright (c) 2014 Artur Klepaczko. All rights reserved.
//

#ifndef __BasicVascularModeling__CommonDefinitions__
#define __BasicVascularModeling__CommonDefinitions__

typedef struct _Point3D {
    double x; // [ mm ]
    double y;
    double z;
} Point3D;

#define BloodViscosityInPa_s 0.005 // [ Pa*s ]
#define BifurcationLawPower  6
#define MinimumRadiusInmm 1 // [ mm ]
#define PressureAtOutlets 11102 // [ Pa ]
#define EntryPressure 11202 // [ Pa ]
#define TerminalFlow 0.2e3 // [mm^3/s] 2500 mm^3/s = 2.5 ml/s
#endif
