//
//  Utils.h
//  BasicVascularModeling
//
//  Created by Artur Klepaczko on 27.05.2014.
//  Copyright (c) 2014 Artur Klepaczko. All rights reserved.
//

#ifndef __BasicVascularModeling__Utils__
#define __BasicVascularModeling__Utils__

#include <iostream>
#include "CommonDefinitions.h"
#include "Vessel.h"

double distanceP2P(Point3D pA, Point3D pB);
void setPoint(Point3D* p, double x, double y, double z);
double crossProductNorm(Point3D vA, Point3D vB);
double radiusFromBifurcationLaw(Vessel* parent, Vessel*son, Vessel* daughter, double gamma);
double distanceP2Vector(Point3D x0, Point3D x1, Point3D x2);
void printPoint(Point3D p, char* label);
double dist_Point_to_Segment(Point3D x0, Point3D x1, Point3D x2);
#endif /* defined(__BasicVascularModeling__Utils__) */
