//
//  VascularNetwork.h
//  BasicVascularModeling
//
//  Created by Artur Klepaczko on 27.05.2014.
//  Copyright (c) 2014 Artur Klepaczko. All rights reserved.
//

#ifndef __BasicVascularModeling__VascularNetwork__
#define __BasicVascularModeling__VascularNetwork__

#include <iostream>
#include <vector>
#include "Vessel.h"

class VascularNetwork {
    
    Vessel* _root;
    std::vector<Vessel*> _vesselArray;
    int _numVessels;
    int getIndexOfTheNearestVesselToPoint(Point3D terminal);
    void optimizeSubtree(Vessel* topVessel);
    void scaleRadiiAndUpdatePressuresDownSubtree(Vessel* topVessel, double scalingFactor);
public:
    VascularNetwork(Vessel* rootVessel);
    ~VascularNetwork();
    void addNewTerminal(Point3D newTerminal);
    void listTree(Vessel* topVessel);
    void writeTree(FILE * fp);
};

#endif /* defined(__BasicVascularModeling__VascularNetwork__) */
