//
//  Vessel.h
//  BasicVascularModeling
//
//  Created by Artur Klepaczko on 27.05.2014.
//  Copyright (c) 2014 Artur Klepaczko. All rights reserved.
//

#ifndef __BasicVascularModeling__Vessel__
#define __BasicVascularModeling__Vessel__

#include <iostream>
#include "CommonDefinitions.h"

class Vessel {

    Point3D _inlet; // [ mm ]
    Point3D _outlet; // [ mm ]
    double _radius; // [ mm ]
    double _pressure_in; // [ Pa ]
    double _pressure_out; // [ Pa ]
    double _flow; // [ ml/s ]
    Vessel* _parent;
    Vessel* _son;
    Vessel* _daughter;
    bool _hasParent;
    bool _isParent;
    int ID;
public:
    Vessel(Point3D inlet, Point3D outlet, double flow, double pressure_in, double pressure_out);
    Vessel(Point3D inlet, Point3D outlet, double flow, Vessel* parent, double pressure_out);
    Vessel(Vessel* original);
    void DeleteVesel(bool withSubTree);
    Point3D getInlet();
    Point3D getOutlet();
    bool hasParent();
    bool isParent();
    double getVolume();
    double getFlow() {return _flow;};
    double getPressureOut() {return _pressure_out;};
    double getPressureIn() {return _pressure_in;};
    double getRadius() {return _radius;};
    Vessel* getParent() {return _parent;};
    Vessel* getSon() {return _son;};
    Vessel* getDaughter() {return _daughter;};
    void setRadius(double radius) {_radius = radius;};
//    void setIsParent(bool isparent) {_isparent = isparent;};
    void setIsSon();
    void setIsDaughter();
    void setParent(Vessel* parent) {_parent = parent;};
    void clearParent();
    void setChildren(Vessel* son, Vessel *daughter);
    void setOutllet(Point3D outlet) {_outlet = outlet;};
    void setInlet(Point3D inlet) {_inlet = inlet;};
    void setPressureOut(double pressure) {_pressure_out = pressure;};
    void setPressureIn(double pressure) {_pressure_in = pressure;};
    void accumulateFlow();
    
    int getID() {return ID;};
};

#endif /* defined(__BasicVascularModeling__Vessel__) */
