//
//  main.cpp
//  BasicVascularModeling
//
//  Created by Artur Klepaczko on 27.05.2014.
//  Copyright (c) 2014 Artur Klepaczko. All rights reserved.
//

#include <iostream>
#include "Vessel.h"
#include "VascularNetwork.h"
#include "CommonDefinitions.h"
#include "Utils.h"

int main(int argc, const char * argv[])
{
    
    // Create root vessel
    Point3D RootInlet;
//    setPoint(&RootInlet, 0.0, 0.0, 0.0);
    setPoint(&RootInlet, 13.472, 104.172, 1558.4);
    
    Point3D RootOutlet;
//    setPoint(&RootOutlet, 100.0, 0.0, 0.0);
//    setPoint(&RootOutlet, 50.228, 163.316	, 1609.857); // 17 (tree and subtree 1)
    setPoint(&RootOutlet, 69.239, 137.223, 1595.158);
//    setPoint(&RootOutlet, 26.366, 136.57, 1592.359);     // 11 (subtree 2)
//    setPoint(&RootOutlet, 50.149, 160.707, 1600.758);     // 15 (subtree 3)
    
    printf("main(): Creating root.\n");
    Vessel* RootVessel = new Vessel(RootInlet, RootOutlet, TerminalFlow, EntryPressure, PressureAtOutlets);
    
    // Create vessel array
    VascularNetwork* vascularNet = new VascularNetwork(RootVessel);
    
    // Define matrix of terminal points
//    int numPoints = 3;
//    Point3D terminals[numPoints];
//    setPoint(&terminals[0], 60.0, 0.0, 50.0);
//    setPoint(&terminals[1], 30.0, 0.0, 85.0);
//    setPoint(&terminals[2], 50.0, 0.0, 60.0);

//    int numPoints = 5;
//    Point3D terminals[numPoints];
//    setPoint(&terminals[0], 50.0, 70.0, 30.0);
//    setPoint(&terminals[1], 30.0, -30.0, 85.0);
//    setPoint(&terminals[2], 60.0, -70.0, 10.0);
//    setPoint(&terminals[3], 90.0, 40.0, -20.0);
//    setPoint(&terminals[4], 90.0, -30.0, 10.0);

//    int numPoints = 3;
//    Point3D terminals[numPoints];
//    setPoint(&terminals[0], 60.0, 50.0, 0.0);
//    setPoint(&terminals[1], 40.0, -55.0, 0.0);
//    setPoint(&terminals[2], 45.0, -20.0, 0.0);

//    int numPoints = 9;
//    Point3D terminals[numPoints];
//    setPoint(&terminals[0], 100.0, 50.0, 10.0);
//    setPoint(&terminals[1], 100.0, 35.0, -10.0);
//    setPoint(&terminals[3], 30.0, 45.0, 5.0);
//    setPoint(&terminals[2], 60.0, 40.0, -5.0);
//    setPoint(&terminals[4], 90.0, 20.0, 15.0);
//    setPoint(&terminals[5], 100.0, -25.0, -15.0);
//    setPoint(&terminals[6], 30.0, -30.0, 10.0);
//    setPoint(&terminals[7], 80.0, -50.0, -5.0);
//    setPoint(&terminals[8], 40.0, -20.0, 10.0);

    // Renal arterial tree
    // Subtree 1: 1 22 14 21 12 13 8 9
    // Subtree 2: 2 3 6 7 10 (11)
    // Subtree 3: 4 5 18 19 20 (15)
    int numPoints = 13;
    Point3D terminals[numPoints];
    int t_idx = 0;
    
//    setPoint(&terminals[t_idx], 65.971, 137.875, 1539.862); t_idx++;      // 1
//    setPoint(&terminals[t_idx], 47.521, 137.875, 1544.062); t_idx++;      // 22
//    setPoint(&terminals[t_idx], 39.603, 156.793, 1600.758); t_idx++;      // 14
//    setPoint(&terminals[t_idx], 39.413, 123.523, 1558.061); t_idx++;      // 21
//    setPoint(&terminals[t_idx], 77.09, 133.961, 1583.959); t_idx++;       // 12
//    setPoint(&terminals[t_idx], 68.107, 133.961, 1589.559); t_idx++;      // 13
//    setPoint(&terminals[t_idx], 35.624, 136.57, 1611.957); t_idx++;       // 9
//    setPoint(&terminals[t_idx], 46.215, 136.57, 1608.457); t_idx++;       // 8
//    
//
//    setPoint(&terminals[t_idx], 68.392, 138.527, 1522.461); t_idx++;      // 2
//    setPoint(&terminals[t_idx], 78.196, 137.875, 1561.561); t_idx++;      // 3
//    setPoint(&terminals[t_idx], 66.528, 141.789, 1602.158); t_idx++;      // 6
//    setPoint(&terminals[t_idx], 54.035, 141.789, 1609.157); t_idx++;      // 7
//    setPoint(&terminals[t_idx], 25.815, 136.57, 1605.657); t_idx++;       // 10
//    setPoint(&terminals[t_idx], 26.366, 136.57, 1592.359); t_idx++;       // 11 (terminal for subtree 2)
//
//    
//    setPoint(&terminals[t_idx], 78.448, 137.223, 1573.46); t_idx++;       // 4
//    setPoint(&terminals[t_idx], 69.239, 137.223, 1595.158); t_idx++;      // 5
//    setPoint(&terminals[t_idx], 56.338, 148.965, 1609.857); t_idx++;      // 18
//    setPoint(&terminals[t_idx], 44.809, 124.176, 1539.862); t_idx++;      // 19
//    setPoint(&terminals[t_idx], 57.833, 124.176, 1536.362); t_idx++;      // 20
//    setPoint(&terminals[t_idx], 50.149, 160.707, 1600.758); t_idx++;      // 15 (terminal for subtree 3)
    
    
//    setPoint(&terminals[t_idx], 47.521, 137.875, 1544.062); t_idx++;      // 22
    setPoint(&terminals[t_idx], 40.809, 124.176, 1535.862); t_idx++;      // 19

    setPoint(&terminals[t_idx], 78.448, 137.223, 1573.46); t_idx++;       // 4
    
    setPoint(&terminals[t_idx], 25.815, 136.57, 1605.657); t_idx++;       // 10
        
    setPoint(&terminals[t_idx], 68.392, 138.527, 1522.461); t_idx++;      // 2
    
    setPoint(&terminals[t_idx], 74.528, 141.789, 1546.158); t_idx++;      // 6
    
    setPoint(&terminals[t_idx], 78.196, 137.875, 1561.561); t_idx++;      // 3
    
   setPoint(&terminals[t_idx], 65.971, 137.875, 1539.862); t_idx++;      // 1

    
    setPoint(&terminals[t_idx], 35.624, 136.57, 1611.957); t_idx++;       // 9
    

    
    setPoint(&terminals[t_idx], 46.215, 136.57, 1608.457); t_idx++;       // 8
    

    setPoint(&terminals[t_idx], 21.366, 136.57, 1592.359); t_idx++;       // 11 (terminal for subtree 2)
    

    setPoint(&terminals[t_idx], 77.09, 133.961, 1583.959); t_idx++;       // 12
    setPoint(&terminals[t_idx], 58.107, 133.961, 1589.559); t_idx++;      // 13


    setPoint(&terminals[t_idx], 61.035, 141.789, 1520.157); t_idx++;      // 7

    

    
    
    // Loop over terminal points matrix and add new vessels
    
    for (int i=0; i<numPoints; i++) {
        vascularNet->addNewTerminal(terminals[i]);
    }
    
    // Export VascularNetwork into a text file
    FILE * pFile;
    pFile = fopen ("RenalArterialTree.txt","w");
    vascularNet->writeTree(pFile);
    
    fclose (pFile);
    // Clean up
    delete vascularNet; // safely deletes all vessels inside the net and the net itself
    
    return 0;
}

