﻿using System;

using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO.Ports;

namespace Bluetooth_Chat
{
    public class BtThr
    {
        #region Members

        // Main thread sets this event to stop worker thread:
        ManualResetEvent m_EventStop;

        // Worker thread sets this event when it is stopped:
        ManualResetEvent m_EventStopped;

        // Reference to main form used to make syncronous user interface calls:
        Form1 m_form;

        SerialPort spRx;

        #endregion

        #region Functions

		public BtThr(ManualResetEvent eventStop, 
			               ManualResetEvent eventStopped,
			               Form1 form)
		{
			m_EventStop = eventStop;
			m_EventStopped = eventStopped;
			m_form = form;
            //this.spRx = new System.IO.Ports.SerialPort(this.components);
            this.spRx = new System.IO.Ports.SerialPort("COM7");
            //spRx.PortName = "COM7";
		}

		// Function runs in worker thread.
		public void Run()
		{
			int i;
			String s;
            s = "";

            try
            {
                spRx.Open();
            }
            catch(Exception e)
            {
                m_form.Invoke(m_form.m_DelegateThreadFinished, null);
                return;
            }
            

			for (i = 1; i <= 1000; i++)
			{
                s = "";
                try
                {
                    s = spRx.ReadLine() + "\r\n";
                }
                catch (Exception e)
                {
                }
                // make step
				//s = "Step number " + i.ToString() + " executed" + "\r\n";

				Thread.Sleep(1000);

				// Make synchronous call to main form.
				// MainForm.AddString function runs in main thread.
				// To make asynchronous call use BeginInvoke
				m_form.Invoke(m_form.m_DelegateAddMessage, new Object[] {s});


				// check if thread is cancelled
				/*if ( m_EventStop.WaitOne(0, true) )
				{
					// clean-up operations may be placed here
					// ...

					// inform main thread that this thread stopped
					m_EventStopped.Set();

					return;
				}*/
			}
            spRx.Close();

			// Make asynchronous call to main form
			// to inform it that thread finished
			m_form.Invoke(m_form.m_DelegateThreadFinished, null);
		}

		#endregion
    }
}
