﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;

namespace Bluetooth_Chat
{
    #region Public Delegates

    // delegates used to call Form1 functions from worker thread
    public delegate void DelegateAddMessage(String s);
    public delegate void DelegateThreadFinished();

    #endregion

    public partial class Form1 : Form
    {

        #region Members

        // worker thread
        Thread m_WorkerThread;

        // events used to stop worker thread
        ManualResetEvent m_EventStopThread;
        ManualResetEvent m_EventThreadStopped;

        // Delegate instances used to call user interface functions 
        // from worker thread:
        public DelegateAddMessage m_DelegateAddMessage;
        public DelegateThreadFinished m_DelegateThreadFinished;

        #endregion

        /*
        Thread rxThread;
        Boolean threadRxStop;
        public myDelegateAddMessage m_DelegateAddMessage;
        public delegate void myDelegateAddMessage(String s);*/

        #region Constructor
        public Form1()
        {
            InitializeComponent();
            this.MinimizeBox = false;
            menuItemDisconn.Enabled = false;

            // initialize delegates
            m_DelegateAddMessage = new DelegateAddMessage(this.AddMessage);
            m_DelegateThreadFinished = new DelegateThreadFinished(this.ThreadFinished);

            // initialize events
            m_EventStopThread = new ManualResetEvent(false);
            m_EventThreadStopped = new ManualResetEvent(false);
            
            /*threadRxStop = true;
            // Inicjalizacja delegates
            m_DelegateAddMessage = new myDelegateAddMessage(AddMessage);*/
        }
        #endregion
        #region Message Handlers

        // Start thread button is pressed
        private void btnStartThread_Click(object sender, System.EventArgs e)
        {
            //listBox1.Items.Clear();
            textBoxMessages.Text = "";
            btnStartThread.Enabled = false;
            btnStopThread.Enabled = true;

            // reset events
            m_EventStopThread.Reset();
            m_EventThreadStopped.Reset();

            // create worker thread instance
            m_WorkerThread = new Thread(new ThreadStart(this.WorkerThreadFunction));

            m_WorkerThread.Name = "Worker Thread Sample";	// looks nice in Output window

            m_WorkerThread.Start();

        }

        // Stop Thread button is pressed
        private void btnStopThread_Click(object sender, System.EventArgs e)
        {
            StopThread();
        }

        // Exit button is pressed.
        private void btnExit_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        // Form is closed.
        // Stop thread if it is active.
        private void MainForm_Closed(object sender, System.EventArgs e)
        {
            StopThread();
        }

        #endregion

        #region Other Functions

        // Worker thread function.
        // Called indirectly from btnStartThread_Click
        private void WorkerThreadFunction()
        {
            BtThr btThr;

            btThr = new BtThr(m_EventStopThread, m_EventThreadStopped, this);

            btThr.Run();
        }

        // Stop worker thread if it is running.
        // Called when user presses Stop button of form is closed.
        private void StopThread()
        {
            //if (m_WorkerThread != null && m_WorkerThread.IsAlive)  // thread is active
            if (m_WorkerThread != null)  // thread is active
            {
                // set event "Stop"
                m_EventStopThread.Set();

                // wait when thread  will stop or finish
                /*while (m_WorkerThread.IsAlive)
                {
                    // We cannot use here infinite wait because our thread
                    // makes syncronous calls to main form, this will cause deadlock.
                    // Instead of this we wait for event some appropriate time
                    // (and by the way give time to worker thread) and
                    // process events. These events may contain Invoke calls.
                    if (WaitHandle.WaitAll(
                        (new ManualResetEvent[] { m_EventThreadStopped }),
                        100,
                        true))
                    {
                        break;
                    }

                    Application.DoEvents();
                }*/
            }

            ThreadFinished();		// set initial state of buttons
        }

        // Add string to list box.
        // Called from worker thread using delegate and Control.Invoke
        private void AddMessage(String s)
        {
            //listBox1.Items.Add(s);
            textBoxMessages.Text += s;

        }

        // Set initial state of controls.
        // Called from worker thread using delegate and Control.Invoke
        private void ThreadFinished()
        {
            btnStartThread.Enabled = true;
            btnStopThread.Enabled = false;
        }

        #endregion

        

        private void menuItemConn_Click(object sender, EventArgs e)
        {
            //if (serialPortRx.IsOpen)
                //serialPortRx.Close();
            if (serialPortTx.IsOpen)
                serialPortTx.Close();

            //serialPortRx.Open();
            serialPortTx.Open();
            menuItemConn.Enabled = false;
            menuItemDisconn.Enabled = true;

            //threadRxStop = false;
            //rxThread = new Thread(receiveProc);
            //rxThread.Start();
        }

        private void menuItemDisconn_Click(object sender, EventArgs e)
        {
            //threadRxStop = true;
            //serialPortRx.Close();
            serialPortTx.Close();
            menuItemConn.Enabled = true;
            menuItemDisconn.Enabled = false;
        }
        /*
        void receiveProc()
        {
            //
            string rdLn;
            rdLn = "";
            while (true)
            {
                if (threadRxStop == true)
                    break;
                else
                {
                    try
                    {
                        rdLn = serialPortRx.ReadLine();
                    }
                    catch (Exception ex)
                    {
                    }
                    if (rdLn.Length != 0)
                    {
                        //BtMsgReceived(this, new BtMsgReceivedEventArgs(123));
                        //m_form.Invoke(m_form.m_DelegateAddString, new Object[] {s});
                        m_DelegateAddMessage.Invoke(rdLn.ToString());
                    }
                    Application.DoEvents();
                }
            }
        }

        public void AddMessage(String s)
        {
            try
            {
                textBoxMessages.Text = s;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString());
            }
        }

        */
        private void buttonSend_Click(object sender, EventArgs e)
        {
            //
            if (textBoxSend.Text.Length != 0)
            {
                serialPortTx.WriteLine(textBoxSend.Text);
                AddMessage(textBoxSend.Text + "\r\n");
                //textBoxMessages.Text += textBoxSend.Text + "\r\n";
                textBoxSend.Text = "";
            }
        }

     }
}