﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.IO;

namespace IrDAComm
{
    public partial class Form1 : Form
    {
        private IrDAListener irListen;
        private IrDAClient irClient;
        private IrDAEndPoint irEndP;
        private IrDADeviceInfo[] irDevices;

        string fileSend;
        string fileReceive;
        string irServiceName;

        int buffersize;

        public Form1()
        {
            InitializeComponent();

            irClient = new IrDAClient();

            // Pliki do wysyłania / odbioru danych
            fileSend = ".\\My Documents\\send.txt";
            fileReceive = ".\\My Documents\\receive.txt";

            // Nazwa usługi - jednakowa dla wszystkich urządzeń!!!
            irServiceName = "IrDAFtp";

            // Maksymalna długość bufora
            buffersize = 256;

            this.MinimizeBox = false;

            // Przyciski Send i Receive są zablokowane 
            // do czasu uzyskania połączenia
            btnSend.Enabled = false;
            btnReceive.Enabled = false;

        }

        //Odbieranie danych
        private void btnReceive_Click(object sender, EventArgs e)
        {
            // Strumień zapisu odebranych danych do pliku
            Stream writeStream;
            try
            {
                writeStream = new FileStream(fileReceive,
                    FileMode.OpenOrCreate);
            }
            catch (Exception)
            {
                MessageBox.Show("Couldn't open "
                    + fileReceive + " for writing");
                return;
            }

            // Utworzenie połączenia z zaznaczonym urządzeniem
            try
            {
                int i = listBox1.SelectedIndex;
                irEndP = new IrDAEndPoint(irDevices[i].DeviceID,
                    irServiceName);
                irListen = new IrDAListener(irEndP);
                irListen.Start();
            }
            catch (SocketException exSoc)
            {
                MessageBox.Show("Couldn't listen on service "
                    + irServiceName + ": "
                    + exSoc.ErrorCode);
            }

            statusBar1.Text = "Listening for "
                + listBox1.SelectedItem.ToString();

            // Utworzenie połączenia dla wykrytej usługi
            // SERVICE_NAME - takie samo!!!
            IrDAClient irClient;
            try
            {
                irClient = irListen.AcceptIrDAClient();
            }
            catch (SocketException exp)
            {
                MessageBox.Show("Couldn't accept socket "
                    + exp.ErrorCode);
                return;
            }

            // Połączenie w toku
            if (irListen.Pending() == true)
                statusBar1.Text = "Pending from "
                    + irClient.RemoteMachineName;
            else
                statusBar1.Text = "Not pending from "
                    + irClient.RemoteMachineName;

            // Odczyt strumienia danych
            Stream baseStream = irClient.GetStream();

            int numToRead;

            // Bufor
            byte[] buffer = new byte[buffersize];

            // Odczyt danych z urządzenia
            numToRead = 4;
            while (numToRead > 0)
            {
                int numRead = baseStream.Read(buffer, 0, numToRead);
                numToRead -= numRead;
            }

            // Odczyt długości strumienia danych
            numToRead = BitConverter.ToInt32(buffer, 0);
            statusBar1.Text = "Going to write "
                + numToRead + " bytes";

            // Zapis strumienia do pliku
            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            while (numToRead > 0)
            {
                int numRead = baseStream.Read(buffer, 0, buffer.Length);
                numToRead -= numRead;
                writeStream.Write(buffer, 0, numRead);                
                textBox1.Text += enc.GetString(buffer,0,buffer.Length);
            }

            // Potwierdzenie transmisji dla użytkownika
            statusBar1.Text = "File received";

            baseStream.Close();
            writeStream.Close();
            irListen.Stop();
            irClient.Close();
        }

        //Wykrywanie urządzeń w zasięgu
        private void btnDiscover_Click(object sender, EventArgs e)
        {
            // Utworzenie listy dostępnych urządzeń (max. 3)
            irDevices = irClient.DiscoverDevices(2);

            // Okno dialogowe, gdy nie ma urządzeń w zasięgu
            if (irDevices.Length == 0)
            {
                MessageBox.Show("No remote infrared devices found!");
                return;
            }

            // Lista dostępnych urządzeń
            // oraz ich właściwości
            string device;
            int ID;
            listBox1.Items.Clear();
            foreach (IrDADeviceInfo irDevice in irDevices)
            {
                ID = BitConverter.ToInt32(irDevice.DeviceID, 0);
                device = ID.ToString() + " " + irDevice.DeviceName + " "
                    + irDevice.CharacterSet + " " + irDevice.Hints;
                listBox1.Items.Add(device);
            }

            listBox1.SelectedIndex = 0;
            if (irDevices.Length > 0)
                statusBar1.Text =
                    irDevices.Length.ToString() + " remote device(s)";


            // Odblokowanie przycisków Send i Receive
            btnSend.Enabled = true;
            btnReceive.Enabled = true;

        }

        //Wysyłanie danych
        private void btnSend_Click(object sender, EventArgs e)
        {
            // Otwarcie pliku i odczyt strumienia zapisanych danych
            Stream fileStream;
            try
            {
                fileStream = new FileStream(fileSend, FileMode.Open);
            }
            catch (Exception exFile)
            {
                MessageBox.Show("Cannot open " + exFile.ToString());
                return;
            }

            // Utworzenie klienta IrDA i usługi o odpowiedniej nazwie
            try
            {
                irClient = new IrDAClient(irServiceName);
            }
            catch (SocketException exS)
            {
                MessageBox.Show("Create socket error: " + exS.Message +
                    " - Did you click Receive on the other device?");
                return;
            }

            // Dostęp do strumienia danych klienta
            Stream baseStream = irClient.GetStream();

            // Rozmiar przesyłanego pliku, zapis do strumienia
            byte[] length = BitConverter.GetBytes((int)fileStream.Length);
            baseStream.Write(length, 0, length.Length);

            // Bufor danych odczytywanych z pliku
            byte[] buffer = new byte[buffersize];

            // Liczba wysyłanych bajtów
            int fileLength = (int)fileStream.Length;
            statusBar1.Text = "Sending " + fileLength + " bytes";

            // File strem -> Base Stream
            while (fileLength > 0)
            {
                int numRead = fileStream.Read(buffer, 0, buffer.Length);
                baseStream.Write(buffer, 0, numRead);
                fileLength -= numRead;
            }

            //Zamknięcie strumieni i klienta
            fileStream.Close();
            baseStream.Close();
            irClient.Close();
            
            //Potwierdzenie przesłania pliku
            statusBar1.Text = "File sent";

        }
    }
}