﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Text;
using System.Windows.Forms;

//Zadanie
// Wykorzystać timer, żeby móc automatycznie odczytywać komunikaty linia po linii


namespace MobileGPS
{
    public partial class FormGPS : Form
    {
        //Łańcuch przechowujący odczytaną linię tekstu z odbiornika GPS
        string gpsLine;
        private StreamWriter sw = null;

        //Inicjalizacja głównego formularza aplikacji
        public FormGPS()
        {
            InitializeComponent();
            this.MinimizeBox = false;

            textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
        }

        //Czynności wykonywane podczas ładowania formularza głównego
        private void FormGPS_Load(object sender, EventArgs e)
        {
            //Zapełnienie kontrolki combobox nazwami dostępnych portów (COM1, COM2, ...)

            comboBoxPort.Items.Clear();
            string[] ports = SerialPort.GetPortNames();
            foreach (string prt in ports)
            {
                comboBoxPort.Items.Add(prt);
            }
        }

        //Połączenie/rozłączenie ze wskazanym portem
        private void buttonPort_Click(object sender, EventArgs e)
        {
            if (buttonPort.Text == "Open")
            {
                if (serialPort1.IsOpen)
                {
                    serialPort1.Close();
                }
                int id = comboBoxPort.SelectedIndex;
                if (id > 0)
                {
                    serialPort1.PortName = comboBoxPort.Items[id].ToString();

                    if (!serialPort1.IsOpen)
                    {
                        serialPort1.Open();

                        //Ustawienie szybkości transmisji danych portu
                        string br = "4800";
                        serialPort1.BaudRate = Convert.ToInt32(br);
                        if (serialPort1.IsOpen)
                        {
                            buttonPort.Text = "Close";
                            //Wyświetlenie odczytanej szybkości transmisji (można usunąć)
                            statusBar1.Text = "Port OK, Baud Rate: " + serialPort1.BaudRate.ToString();
                        }
                    }
                }
            }
            else
            {
                if (serialPort1.IsOpen)
                {
                    serialPort1.Close();
                }
                if (!serialPort1.IsOpen)
                {
                    statusBar1.Text = "Port Successfully Closed";
                    buttonPort.Text = "Open";
                }
            }

        }

        //Czynności wykonywane podczas zamykania aplikacji - zamknięcie portu
        private void FormGPS_Closing(object sender, CancelEventArgs e)
        {
            if (serialPort1.IsOpen)
            {
                serialPort1.Close();
            }
        }

        //Odczyt danych z GPS (pojedynczej linii)
        private void buttonReadGps_Click(object sender, EventArgs e)
        {
            if (serialPort1.IsOpen)
            {
                gpsLine = serialPort1.ReadLine() + "\n";
                textBox1.Text += gpsLine;
                extractCoordinates(gpsLine);
            }
        }

        private void extractCoordinates(string gpsMessage)
        {
            //Odczytanie współrzędnych z linii komunikatu GPS ($GPGGA lub $GPRMC) i wyświetlenie współrzędnych w pasku statusu
            
            if (gpsMessage.StartsWith("$GPGGA"))
            {
                string[] result;
                result = gpsMessage.Split(',');

                try
                {
                    if (result[2] != "")
                    {
                        statusBar1.Text = "Lat: " + result[3] + result[2] + "; Lon: " + result[5] + result[4];
                    }
                }
                catch (Exception Ex)
                {
                }
            }
            else if (gpsMessage.StartsWith("$GPRMC"))
            {
                string[] result;
                result = gpsMessage.Split(',');
                try
                {
                    if (result[3] != "")
                    {
                        statusBar1.Text = "Lat: " + result[4] + result[3] + "; Lon: " + result[6] + result[5];
                    }
                }
                catch(Exception Ex)
                {
                }
            }
        }

        private void buttonExit_Click(object sender, EventArgs e)
        {
            timerLogGps.Enabled = false;
            Close();
        }

        private void buttonLogGps_Click(object sender, EventArgs e)
        {
            if (buttonLogGps.Text == "Log GPS Data")
            {
                sw = new StreamWriter("test.txt", true);
                timerLogGps.Enabled = true;
                buttonLogGps.Text = "Stop Logging GPS Data";
            }
            else
            {
                timerLogGps.Enabled = false;
                sw.Close();
                buttonLogGps.Text = "Log GPS Data";
            }
        }

        private void timerLogGps_Tick(object sender, EventArgs e)
        {
            if (textBox1.TextLength > 300)
            {
                textBox1.Text= "";
            }
            if (serialPort1.IsOpen)
            {
                gpsLine = serialPort1.ReadLine() + "\n";
                if (checkBoxGprmc.Checked)
                {
                    if (gpsLine.StartsWith("$GPRMC"))
                    {
                        textBox1.Text += gpsLine;
                        sw.Write(gpsLine);
                        extractCoordinates(gpsLine);
                    }
                }
                else
                {
                    textBox1.Text += gpsLine;
                    sw.Write(gpsLine);
                    extractCoordinates(gpsLine);
                }
            }
        }
    }
}