﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.PocketOutlook.MessageInterception;
using System.Reflection;

namespace SMS_Msg
{
    public partial class Form1 : Form
    {
        MessageInterceptor msgInterceptor;
        Guid appID = new Guid("{5FCE51C5-44D6-48b8-8CAF-F333975A39E3}");

        public Form1()
        {
            InitializeComponent();
            this.MinimizeBox = false;
        }

        private void buttonSendSms_Click(object sender, EventArgs e)
        {
            try
            {
                SmsMessage sms = new SmsMessage();
                
                sms.Body = textBoxMsg.Text;
                
                sms.To.Add(new Recipient(textBoxNo.Text));
                sms.RequestDeliveryReport = true;
                sms.Send();
                statusBar1.Text = "Message sent!";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            if (MessageInterceptor.IsApplicationLauncherEnabled(appID.ToString()))
            {
                msgInterceptor = new MessageInterceptor(appID.ToString(), true);
            }
            else
            {
                msgInterceptor = new MessageInterceptor(InterceptionAction.NotifyAndDelete, true);

                //msgInterceptor.MessageCondition = new MessageCondition(MessageProperty.Body,
                //       MessagePropertyComparisonType.StartsWith,"Hello", false);

                
                string appPath = Assembly.GetExecutingAssembly().GetName().CodeBase;
                msgInterceptor.EnableApplicationLauncher(appID.ToString(), appPath);
            }

            msgInterceptor.MessageReceived += new MessageInterceptorEventHandler(msgInterceptor_MessageReceived);
      }

        void msgInterceptor_MessageReceived(object sender, MessageInterceptorEventArgs e)
        {
            //Obsługa odbioru wiadomości
            SmsMessage smsReceived = (SmsMessage)e.Message;
            textBoxMsgReceived.Text = "";
            textBoxMsgReceived.Text = "Message from: " + smsReceived.From.ToString() + "/n";
            textBoxMsgReceived.Text += smsReceived.Body;
            statusBar1.Text = "Message received!";

            String appPath = Assembly.GetExecutingAssembly().GetName().CodeBase;
            System.Diagnostics.Process.Start(appPath, "");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (MessageInterceptor.IsApplicationLauncherEnabled(appID.ToString()))
            {
                msgInterceptor.DisableApplicationLauncher();

                msgInterceptor.MessageReceived -= msgInterceptor_MessageReceived;
                msgInterceptor.Dispose();
                if (!MessageInterceptor.IsApplicationLauncherEnabled(appID.ToString()))
                    MessageBox.Show("Application unregistered.");
                else
                    MessageBox.Show("Application not unregistered");
            }

        }
    }
}