/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <ColumnCollection.h>
#include <Sharption.h>

void ColumnCollection::Add( Column col )
{
	cols.push_back( col );
}
void ColumnCollection::Add(const char* name, int type )
{
	Column col;
	col.name = name;
	col.type = type;

	cols.push_back( col );
}
Column ColumnCollection::operator[](unsigned int index)
{
	if( index > cols.size() )
		throw Sharption("Index out of range");
	return cols[index];
}
Column ColumnCollection::operator[](const char* name)
{
	for(unsigned int i = 0; i < cols.size(); i++)
		if( !strcmp(cols[i].name.c_str(), name ) )
			return cols[i];

	throw Sharption("There is no such column");
}

bool ColumnCollection::operator==(const ColumnCollection& cc )
{
	if( cols.size() != cc.cols.size() )
		return false;
	for(unsigned int i = 0; i < cols.size(); ++i)
	{
		if( cols[i].name != cc.cols[i].name || cols[i].type != cc.cols[i].type)
			return false;
	}
	return true;
}
unsigned int ColumnCollection::Count()
{
	return cols.size();
}
