/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <Row.h>
#include <Sharption.h>

Row::Row(){}

Row::Row(ColumnCollection* columns)
{
	owned = false;
	cols = columns;
	values = new Cell[cols->Count()];

	for(unsigned int i = 0; i < cols->Count(); i++)
	{
		values[i].order = (unsigned short)i;
	}
}
Cell& Row::operator[](unsigned int index)
{
	if( index > cols->Count() )
		throw Sharption("Index out of range");

		//std::exception e();

	return values[index];
}
Cell& Row::operator[](string name)
{
	for( unsigned int i = 0; i < cols->Count(); ++i)
	{
		if( (*cols)[i].name == name )
			return values[i];
	}
    throw Sharption("There is no such column");
}

Row::~Row()
{
	if( values )
	{
		if( cols->Count() > 1 )
			delete[] values;
		else
			delete values;
	}
}
