/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <SQLiteCommand.h>
#include <Sharption.h>

SQLiteCommand::SQLiteCommand(const string& sql_cmd = 0, SQLiteConnection* connection = 0)
{
	cmd = sql_cmd;
	cnn = connection;
}

SQLiteCommand::~SQLiteCommand(void)
{
}

int SQLiteCommand::ExecuteNonQuery()
{
	if( cnn->State() != STATE_OPEN )
		throw Sharption("Failure: Connection must be valid and open!");

	char* msg;
	int result = sqlite3_exec(cnn->db, cmd.c_str(), 0, 0, &msg);

	if( result != SQLITE_OK )
	{
		string err = msg;
		sqlite3_free(msg);
		throw Sharption(err.c_str());
	}
	return sqlite3_changes(cnn->db);
}

SQLiteDataReader SQLiteCommand::ExecuteReader()
{
	return SQLiteDataReader(cmd.c_str(),cnn->db);
}