/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <SQLiteConnection.h>


SQLiteConnection::SQLiteConnection():_state(STATE_CLOSED)
{
}
SQLiteConnection::SQLiteConnection(string database):_state(STATE_CLOSED)
{
	db_name = database;	
}

SQLiteConnection::~SQLiteConnection()
{
	
}

int SQLiteConnection::Open()
{
	int result = sqlite3_open(db_name.c_str(), &db);
	
	if( result == SQLITE_OK )
		_state = STATE_OPEN;
	else
		_state = STATE_CLOSED;

	return result;
}

int SQLiteConnection::Close()
{
	int result = sqlite3_close(db);

	if( result == SQLITE_OK )
		_state = STATE_CLOSED;
	else
		_state = STATE_OPEN;

	return result;
}
int SQLiteConnection::State()
{
	return _state;
}
int SQLiteConnection::ChangeDatabase(string database)
{
	//not yet implemented
	return -1;
}
