/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <SQLiteDataAdapter.h>
#include <Sharption.h>

SQLiteDataAdapter::SQLiteDataAdapter(const string& SelectCmd, SQLiteConnection* connection)
{
	select_cmd = SelectCmd;
	cnn = connection;
}
SQLiteDataAdapter::~SQLiteDataAdapter(void)
{
}

void SQLiteDataAdapter::Fill(DataTable& table)
{
	if( cnn->State() != STATE_OPEN )
		throw Sharption("This operation requires a valid and open connection");

	SQLiteCommand cmd(select_cmd, cnn);

	SQLiteDataReader reader = cmd.ExecuteReader();

	for( unsigned int i = 0; i < reader.columns(); ++i)
		table.cols.Add( reader.GetColumnName(i), reader.GetColumnType(i) );

	while(reader.Read())
	{
		Row* row = table.RequestRow();

		for(unsigned int i = 0; i < reader.columns() ; ++i)
			(*row)[i] = reader[i];

		table.Add(row);
	}
}
