#include "MainFrm.h"
#include "resource.h"

#include <GDI.h>
#include <math.h>
#include <aygshell.h>

CMainFrame::CMainFrame()
{
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
    switch (LOWORD(wParam))
    {
        case IDM_HELP_ABOUT:
        {
            CDialog HelpDialog(IDW_ABOUT, m_hWnd);
            HelpDialog.DoModal();
        }
        break;

        // Respond to the accelerator key
        case IDW_QUIT:
            ::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
            break;
    }

    switch (HIWORD(wParam))
    {
        default:
    	    break;
    }

    return 0;
}

void CMainFrame::PreCreate(CREATESTRUCT &cs)
{
    cs.style = WS_VISIBLE;
    cs.lpszClass = _T("frame");    
}

void CMainFrame::OnInitialUpdate()
{
}

void CMainFrame::SetupWindow()
{
    fo = fopen("\\Storage Card\\test.log", "wb");
    fprintf(fo, "Setup window\r\n");
    Graphics::Bitmap::log = fo;
    
    ::SHFullScreen(m_hWnd, SHFS_HIDESTARTICON | SHFS_HIDESIPBUTTON | SHFS_HIDETASKBAR);
    ::MoveWindow(m_hWnd, 0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN), TRUE);
    ::UpdateWindow(m_hWnd);
    
    RECT r = GetClientRect();
    
    bgk = new Graphics::Bitmap(GetApp()->GetInstanceHandle(), IDB_BGK);
    bgk->getBits();
    
    bStart.setCommandId(IDB_START);
    bStart.setAlpha(100);
    bStart.setBackground(*bgk);
    bStart.setNormalBitmap(LoadBitmap(MAKEINTRESOURCE(IDB_START)));
    bStart.setActiveBitmap(LoadBitmap(MAKEINTRESOURCE(IDB_STARTA)));
    bStart.Create(m_hWnd);
    bStart.MoveWindow(r.left + 10, r.top + 10, 21, 21);
    bStart.ShowWindow();
}

void CMainFrame::OnPaint(HDC hDC)
{
    HDC dc = ::GetDC(NULL);
    bgk->draw(dc);
    ::ReleaseDC(NULL, dc);
}

LRESULT CMainFrame::WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    // handle left mouse button up/down and mouse move messages
    // a seperate function for each case keeps the code tidy.
    switch (uMsg)
    {
	case WM_CREATE:
	    SetupWindow();
	    break;
	case WM_CLOSE:
	    fclose(fo);
	    break;
        case WM_LBUTTONDOWN:
            SendMessage(hwnd, WM_CLOSE, 0, 0);
            break;
        case WM_MOUSEMOVE:
            break;
        case WM_LBUTTONUP:
            break;
    }

    // Pass unhandled messages on to WndProcDefault
    return WndProcDefault(hwnd, uMsg, wParam, lParam);
}

