#ifndef DATABASE_H
#define DATABASE_H

#include <SQLiteConnection.h>
#include <string>

class Database
{
public:
    inline Database();
    inline ~Database();
    inline void setDBPath(std::string dbFileName);
    inline void open();
    inline void close();
    inline bool isConnected();
    inline SQLiteConnection* getConnection();
private:
    bool connected;
    SQLiteConnection* conn;
};

inline Database::Database()
    : connected(0), conn(0)
{
}

inline Database::~Database()
{
    close();
    if (conn)
        delete conn;
}

inline void Database::setDBPath(std::string dbFileName)
{
    close();
    if (conn)
        delete conn;
    conn = new SQLiteConnection(dbFileName);
}

inline void Database::open()
{
    if (conn)
    {
        conn->Open();
        connected = true;
    }
}

inline void Database::close()
{
    if (connected)
        conn->Close();
}

inline bool Database::isConnected()
{
    return connected;
}

inline SQLiteConnection* Database::getConnection()
{
    return conn;
}

#endif
