#include <GDI.h>
#include <math.h>
#include <aygshell.h>
#include <stdlib.h>
#include <strtool.h>

#include "MainFrm.h"
#include "resource.h"

#define TEST

CMainFrame::CMainFrame()
{
    // Set the Resource IDs for the toolbar buttons
    m_ToolbarData.clear();
    m_ToolbarData.push_back(0);         // Separator
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
    switch (LOWORD(wParam))
    {
        case IDM_HELP_ABOUT:
        {
            CDialog HelpDialog(IDW_ABOUT, m_hWnd);
            HelpDialog.DoModal();
        }
        break;

        // Respond to the accelerator key
        case IDW_QUIT:
            ::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
            break;
    }

    return 0;
}

void CMainFrame::OnInitialUpdate()
{
    SHFullScreen(m_hWnd, SHFS_HIDESIPBUTTON);
    gps = new GPS("COM1", 9600);
#ifdef TEST
    updateGPS();
#endif
}

void CMainFrame::OnPaint(HDC hDC)
{
    WCHAR temp[256];
    Win32xx::GradientFill(hDC, RGB(0, 0, 128), RGB(0, 128, 255), GetViewRect(), true);
    
    CRect vr = GetViewRect();
    CDC dc(hDC);
    
    LOGFONT font;
    font.lfHeight = (-14 * GetDeviceCaps(hDC, LOGPIXELSY)) / 72; 
    font.lfWidth = 0; 
    font.lfEscapement = 0; 
    font.lfOrientation = 0; 
    font.lfWeight = FW_NORMAL; 
    font.lfItalic = false; 
    font.lfUnderline = false; 
    font.lfStrikeOut = false; 
    font.lfCharSet = DEFAULT_CHARSET; 
    font.lfOutPrecision = OUT_DEFAULT_PRECIS; 
    font.lfClipPrecision = CLIP_DEFAULT_PRECIS; 
    font.lfQuality = ANTIALIASED_QUALITY; 
    font.lfPitchAndFamily = FF_SWISS | DEFAULT_PITCH; 
    wcscpy(font.lfFaceName, TEXT("Arial"));
    dc.CreateFontIndirect(&font);
    
    SetTextAlign(hDC, TA_LEFT | TA_TOP);
    SetTextColor(hDC, RGB(255, 255, 255));
    SetBkMode(hDC, TRANSPARENT);
    int lh = abs(font.lfHeight) + 2;
    int cy = vr.top + 8;
    
    CRect dr = CRect(4, cy, vr.right - 4, cy + lh);
    ::DrawText(hDC, gpsInfo.lon, wcslen(gpsInfo.lon), &dr, DT_LEFT | DT_TOP);
    cy += lh;
    dr = CRect(4, cy, vr.right - 4, cy + lh);
    ::DrawText(hDC, gpsInfo.lat, wcslen(gpsInfo.lat), &dr, DT_LEFT | DT_TOP);
    cy += lh;

        
    HFONT hFont = dc.DetachFont();
    DeleteObject(hFont);
}

LRESULT CMainFrame::WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    // handle left mouse button up/down and mouse move messages
    // a seperate function for each case keeps the code tidy.
    switch (uMsg)
    {
        case WM_GPS:
    	    updateGPS();
            break;
    }

    // Pass unhandled messages on to WndProcDefault
    return WndProcDefault(hwnd, uMsg, wParam, lParam);
}

void CMainFrame::updateGPS()
{
    gpsInfo.timeStamp = gps->getTimeStamp();
    double lon = gps->getLongitude();
    double lat = gps->getLatitude();
    wsprintf(gpsInfo.lon, L"%.4f%c", fabs(lon), lon > 0 ? 'E' : 'W');
    wsprintf(gpsInfo.lat, L"%.4f%c", fabs(lat), lat > 0 ? 'N' : 'S');
    gpsInfo.speed = gps->getVelocity();
    gpsInfo.course = gps->getCourse();
    InvalidateRect((LPRECT)GetClientRect(), FALSE);
}

