#include <httpsocket.h>
#include <stdio.h>
#include <string>

int main(int argc, char** argv)
{
    HttpSocket s;
    int port = 80;
    
    Socket::startup();
    int r = s.create();
    if (r)
        return 1;
        
    const char* path = argc > 2 ? argv[2] : "/";
        
    if (argc > 3)
        port = atoi(argv[3]);
    r = s.connect(argv[1], port);
    if (r)
    {
        perror("Cannot connect");
        return 1;
    }
    else
        printf("Connected\n");
    
    r = s.get(path);
    
    if (r)
    {
        perror("Send request");
        return 1;
    } 
    else
        printf("Request sent\n");
    
    std::string resp = s.readResponse();
    //printf("\n---Content---\n%s\n-------------\n", resp.c_str());
    FILE* fo = fopen("content.txt", "wb");
    fwrite(resp.c_str(), 1, resp.length(), fo);
    fclose(fo);
    
    Socket::shutdown();
}

