#ifndef TEXTCODEC_H
#define TEXTCODEC_H

#include "strtool.h"

class TextCodec
{
public:
    /**
     * select source and target encoding, transcode the string
     */ 
    static void selectSourceEncoding(const char* name);
    static void selectTargetEncoding(const char* name);
    static void xcode(const char* strin, char* strout);
    
    /**
     * Converts utf8 string to utf16 string
     */ 
    static void toUtf16(const char* strin, unsigned short* strout);
    
    /**
     * Converts utf8 string to ascii string constaining only latin characters
     */ 
    static void toLatin(const char* strin, char* strout);
    static void toLatin(const uchar16_t* strin, char* strout);
private:
    typedef enum {
        Utf8 = 0,
        Iso2,
        Win1250
    } eEncoding;
    static unsigned short utf8To16(unsigned char** p);
    static int utf16To8(unsigned ucode, char* uc);
    
    static eEncoding srcEncoding;
    static eEncoding destEncoding;
    static unsigned short* m_pgmap;
    static unsigned char m_u16map[0x10000];
};

#endif // TEXTCODEC_H
