﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace SocketClient
{
    public partial class Form1 : Form
    {
        #region Members

        static string output = "";
        Thread serverThread;
        ManualResetEvent m_EventStopThread;

        #endregion

        public Form1()
        {
            InitializeComponent();
            m_EventStopThread = new ManualResetEvent(false);
        }

        public void Connect(string serverIP, string message)
        {
            string output = "";

            try
            {
                // Create a TcpClient.
                // The client requires a TcpServer that is connected
                // to the same address specified by the server and port
                // combination.
                Int32 port = 8080;
                TcpClient client = new TcpClient(serverIP, port);

                // Translate the passed message into ASCII and store it as a byte array.
                Byte[] data = new Byte[256];
                data = System.Text.Encoding.ASCII.GetBytes(message);

                // Get a client stream for reading and writing.
                // Stream stream = client.GetStream();
                NetworkStream stream = client.GetStream();

                // Send the message to the connected TcpServer. 
                stream.Write(data, 0, data.Length);

                output = "Sent: " + message;
                //MessageBox.Show(output);
                textBox1.Text += "Client sent : ";
                textBox1.Text += output;
                textBox1.Text += "\r\n";

                // Buffer to store the response bytes.
                data = new Byte[256];

                // String to store the response ASCII representation.
                String responseData = String.Empty;

                // Read the first batch of the TcpServer response bytes.
                Int32 bytes = stream.Read(data, 0, data.Length);
                responseData = System.Text.Encoding.ASCII.GetString(data, 0, bytes);
                output = "Received: " + responseData;
                //MessageBox.Show(output);
                textBox1.Text += "Server responded: ";
                textBox1.Text += output;
                textBox1.Text += "\r\n";

                // Close everything.
                stream.Close();
                client.Close();
            }
            catch (ArgumentNullException e)
            {
                output = "ArgumentNullException: " + e;
                MessageBox.Show(output);
            }
            catch (SocketException e)
            {
                output = "SocketException: " + e.ToString();
                MessageBox.Show(output);
            }
        }




        #region Server

    
        public void ServerThreadFunction()
        {
            SrvThr srvThr;

            srvThr = new SrvThr(m_EventStopThread, this);

            srvThr.Run();
        }


        private void button1_Click(object sender, EventArgs e)
        {
            //serverThread = new Thread(new ThreadStart(this.WorkerThreadFunction));
            serverThread = new Thread(new ThreadStart(this.ServerThreadFunction));

            serverThread.Name = "Server Thread";

            serverThread.Start();

            label2.Text = " uruchomiono! ";
            //this.createListener();
        }
        #endregion

        #region Client Buttons

        private void btnConn_Click_1(object sender, EventArgs e)
        {
            string serverIP = comboBox1.Text;
            string message = "Hello";
            Connect(serverIP, message);
            label1.Text = "Polaczony";
        }
        #endregion

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            m_EventStopThread.Set();
        }


    }
}