/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#ifndef CELL_H
#define CELL_H

#include <string>

using namespace std;

class Row;

class Cell
{
protected:
	string _v;
	unsigned short order;

	friend class Row;
public:

	void operator=(const char* value)
	{
		if(!value && !_v.size())
			return;

		_v.assign( value );
	}
	void operator=(string value)
	{
		this->operator =(value.c_str() );
	}
	const char* c_str()
	{
		return _v.c_str();
	}
	Cell(){}
	~Cell(){}
};

#endif //CELL_H
