/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#ifndef ROW_H
#define ROW_H

#include "Cell.h"
#include "ColumnCollection.h"
#include <string>

class DataTable;

class Row
{
protected:
	ColumnCollection* cols;
	Cell* values;
	bool owned;
	unsigned int order;

	Row();
	Row(ColumnCollection* columns);

	friend class RowCollection;
	friend class DataTable;
public:
	Cell& operator[](unsigned int index);
	Cell& operator[](string name);

	~Row();
};

#endif//ROW_H
