/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#ifndef SQLITECONNECTION_H
#define SQLITECONNECTION_H

#include "sqlite3.h"
#include <string>

using namespace std;

#define STATE_BROKEN	5000
#define STATE_OPEN		5001
#define STATE_CLOSED	5002

class SQLiteCommand;

class SQLiteConnection
{
protected:
	sqlite3* db;

	int _state;
	string db_name;
	friend class SQLiteCommand;
public:

	int Open();
	int Close();
	int State();
	int ChangeDatabase(string database);

	SQLiteConnection();
	SQLiteConnection( string database );

	virtual ~SQLiteConnection();
};

#endif//SQLITECONNECTION_H
