/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#ifndef SQLITEDATAADAPTER_H
#define SQLITEDATAADAPTER_H

#include "SQLiteConnection.h"
#include "SQLiteCommand.h"
#include "DataTable.h"

class SQLiteCommandBuilder;

class SQLiteDataAdapter
{
protected:
	SQLiteConnection* cnn;
	string select_cmd;
	
	void Inform(unsigned int row_nr, unsigned short col_nr);

	friend class SQLiteCommandBuilder;
public:

	void Fill(DataTable& table);

	SQLiteDataAdapter(const string& select_cmd=0, SQLiteConnection* connection=0);
	virtual ~SQLiteDataAdapter();
};

#endif//SQLITEDATAADAPTER_H
