/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#ifndef SQLITEDATAREADER_H
#define SQLITEDATAREADER_H

#include "sqlite3.h"
#include <string>
class SQLiteCommand;

class SQLiteDataReader
{
private:
	unsigned int cols;
	unsigned int result;
	int changes;
	char* msg;
	SQLiteDataReader(){}
protected:
	sqlite3* db;
	sqlite3_stmt* stmt;

	SQLiteDataReader(const char* select_sql, sqlite3* database);
	
	friend class SQLiteCommand;
public:
	unsigned int columns();
	bool Read();
	bool Close();

	const char* GetColumnName(unsigned int index);
	int GetColumnType(unsigned int index);
	 
	const char* GetString(unsigned int index);

	const char* operator[](unsigned int index);
	const char* operator[](const char* name);
	


	virtual ~SQLiteDataReader();
};


#endif//SQLITEDATAREADER_H
