/*****************************************************************************************************
* sharplite: ado.net style (native)c++ wrapper for sqlite database                                   *
* copyright (c) 2006 ademirtug                                                                       *
*                                                                                                    *
* This program is free software; you can redistribute it and/or modify it under the terms of the     *
* GNU General Public License as published by the Free Software Foundation; either version 2 of the   *
* License, or (at your option) any later version.                                                    *
*                                                                                                    *
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without  *
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
* General Public License for more details.                                                           *
*                                                                                                    *
* You should have received a copy of the GNU General Public License along with this library; if not, *
* write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                                                    *
******************************************************************************************************/


#include <SQLiteDataReader.h>
#include <Sharption.h>

SQLiteDataReader::SQLiteDataReader(const char* select_sql, sqlite3* database)
    : msg(0), stmt(0)
{
	db = database;

	result = sqlite3_prepare(db, select_sql, strlen(select_sql), &stmt, 0);

	if( result != SQLITE_OK )
	{
		sqlite3_finalize(stmt);
		throw Sharption( sqlite3_errmsg(db) );
	}

	cols = sqlite3_column_count(stmt);


}

SQLiteDataReader::~SQLiteDataReader()
{
	if( msg )
		sqlite3_free(msg);
	if( stmt )
		sqlite3_finalize(stmt);
}

unsigned int SQLiteDataReader::columns()
{
	return cols;
}


const char* SQLiteDataReader::GetColumnName(unsigned int index)
{
	if( index > cols )
		throw Sharption("Index out of range");

	return sqlite3_column_name(stmt, index);
}
int SQLiteDataReader::GetColumnType(unsigned int index)
{
	if( index > cols )
		throw Sharption("Index out of range");

	return sqlite3_column_type(stmt, index);
}
bool SQLiteDataReader::Read()
{
	result = sqlite3_step(stmt);
	if(result != SQLITE_OK && result != SQLITE_ROW && result != SQLITE_DONE)
	{
		sqlite3_finalize(stmt);
		throw Sharption(sqlite3_errmsg(db));
	}
	if( result == SQLITE_DONE )
		return false;

	return true;
}

bool SQLiteDataReader::Close()
{
	result = sqlite3_finalize(stmt);

	if( result == SQLITE_OK )
		return true;
	return false;
}

const char* SQLiteDataReader::GetString(unsigned int index)
{
	if( index > cols )
		throw Sharption("There is no such column");

	return (const char*)sqlite3_column_text(stmt, index);
}

const char* SQLiteDataReader::operator [](unsigned int index)
{
	return GetString(index);
}

const char* SQLiteDataReader::operator [](const char* name)
{
	for( unsigned int i = 0; i < cols; i++)
	{
		if( strcmp( sqlite3_column_name(stmt,i), name ) == 0)
			return (const char*)sqlite3_column_text(stmt, i);
	}

	throw Sharption("There is no such column");
}
