#ifndef BITBUTTON_H
#define BITBUTTON_H

#include <WinCore.h>
#include <graphics/bitmap.h>

class BitButton : public Win32xx::CWnd
{
public:
    BitButton();
    virtual ~BitButton();
    
    void setCommandId(int id)
    {
        cmdId = id;
    }
    
    void setBackground(Graphics::Bitmap& bkg)
    {
	background = &bkg;
    }
    
    void setNormalBitmap(HBITMAP bmp);
    void setActiveBitmap(HBITMAP bmp);
    void setDisabledBitmap(HBITMAP bmp);
    
    void setAlpha(int alpha);
    
protected:
    void OnPaint(HDC dc);
    void OnMouseDown();
    void OnMouseUp();
    void OnMouseMove();

    virtual void PreCreate(CREATESTRUCT &cs);
    virtual LRESULT WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

protected:
    int bmpAlpha;
    int cmdId;
    Graphics::Bitmap* background;;
    Graphics::Bitmap* bNormal;
    Graphics::Bitmap* bActive;
    Graphics::Bitmap* bDisabled;    
};

#endif // BITBUTTON_H
