#include <DBCombobox.h>
#include <SQLiteCommand.h>
#include <strtool.h>


DBComboBox::DBComboBox()
    : DBControl()
{
}

void DBComboBox::PreCreate(CREATESTRUCT &cs)
{
    cs.style |= WS_CHILD | WS_BORDER | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST;
    cs.lpszClass = _T("combobox");
}

void DBComboBox::loadData()
{
    ::SendMessage(m_hWnd, CB_RESETCONTENT, 0, 0);
    ::SendMessage(m_hWnd, CB_ADDSTRING, 0, (LPARAM)_T(" -- All -- "));

    SQLiteCommand cmd(query, database->getConnection());
    SQLiteDataReader reader = cmd.ExecuteReader();
    while (reader.Read()) 
    {
        int key = atoi(reader[keyName.c_str()]);
        std::string s = getDisplayText(reader);
        WCHAR name[512];
        StrTool::utf8ToUtf16(name, 512, (unsigned char*)s.c_str());
        int idx = ::SendMessage(m_hWnd, CB_ADDSTRING, 0, (LPARAM)name);
        ::SendMessage(m_hWnd, CB_SETITEMDATA, idx, (LPARAM)key);
    }
    reader.Close();
    ::SendMessage(m_hWnd, CB_SETCURSEL, 0, 0);
}

std::string DBComboBox::getDisplayText(SQLiteDataReader& reader)
{
    return reader[valueName.c_str()];
}

