#ifndef DBCONTROL_H
#define DBCONTROL_H

#include <WinCore.h>
#include <SQLiteDataReader.h>
#include "database.h"

class DBControl : public Win32xx::CWnd
{
public:
    DBControl();
    virtual ~DBControl();
    
    void setDatabase(const Database& db);
    void setQuery(std::string qry);
    void setKey(std::string key);
    void setValueField(std::string field);
    void setParamInt(int value);
    void setParamStr(std::string value);
    virtual void loadData() = 0;
    virtual std::string getDisplayText(SQLiteDataReader& reader) = 0;
protected:
    Database* database;
    std::string query;
    std::string keyName;
    std::string valueName;
};

#endif // DBCONTROL_H
