#include "MainFrm.h"
#include "resource.h"

#include <GDI.h>
#include <math.h>
#include <aygshell.h>


CMainFrame::CMainFrame()
{
    DB = new Database();

    // Set the Resource IDs for the toolbar buttons
    m_ToolbarData.clear();
    m_ToolbarData.push_back(0);         // Separator
    m_ToolbarData.push_back(IDM_DATABASE);
    m_ToolbarData.push_back(IDM_CHART);
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
    switch (LOWORD(wParam))
    {
        case IDM_HELP_ABOUT:
        {
            CDialog HelpDialog(IDW_ABOUT, m_hWnd);
            HelpDialog.DoModal();
        }
        break;

        // Respond to Toolbar buttons
        case IDM_DATABASE:
        case IDM_VIEW_DB:
            view.ShowWindow();
            cbGroup.ShowWindow();
            BringWindowToTop(cbGroup);
            break;
        case IDM_VIEW_CHART:
            view.ShowWindow(SW_HIDE);
            cbGroup.ShowWindow(SW_HIDE);
            break;

        // Respond to the accelerator key
        case IDW_QUIT:
            ::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
            break;
    }

    switch (HIWORD(wParam))
    {
        case CBN_DROPDOWN:
            view.ShowWindow(SW_HIDE);
            break;
        case CBN_CLOSEUP:
            updateGrpView();
            view.ShowWindow();
            break;

        case LBN_DBLCLK:
            viewDblClick();
            break;
    }

    return 0;
}

void CMainFrame::OnInitialUpdate()
{
    DB->setDBPath("\\Storage Card\\test.db");
    DB->open();

    SHFullScreen(m_hWnd, SHFS_HIDESIPBUTTON);

    RECT r = GetViewRect();

    cbGroup.Create(m_hWnd);
    cbGroup.MoveWindow(r.left+1, r.top+1, r.right-r.left-2, 200);
    cbGroup.ShowWindow(SW_HIDE);
    cbGroup.setDatabase(*DB);
    cbGroup.setKey("product_group_id");
    cbGroup.setValueField("name");
    cbGroup.setQuery("select * from product_group");
    cbGroup.loadData();
    cbGroup.ShowWindow(SW_SHOW);

    view.Create(m_hWnd);
    view.MoveWindow(r.left+1, r.top+22, r.right-r.left-2, 200);
    view.ShowWindow(SW_HIDE);
    view.setDatabase(*DB);
    view.setValueField("name");
    view.setQuery("select * from product");
    view.setKey("product_id");
//    view.loadData();
}

void CMainFrame::OnPaint(HDC hDC)
{
    Win32xx::GradientFill(hDC, RGB(0, 0, 128), RGB(0, 128, 255), GetViewRect(), true);
/*
    CRect vr = GetViewRect();
    int w = vr.Width();
    int h = vr.Height();
    int sx = vr.left + w/2;
    int sy = vr.top + h/2;
    int Ro = (8 * (w < h ? w/2 : h/2)) / 10;
    int Ri = (3 * Ro) / 4;

    CDC dc(hDC);*/
}

LRESULT CMainFrame::WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    // handle left mouse button up/down and mouse move messages
    // a seperate function for each case keeps the code tidy.
    switch (uMsg)
    {
        case WM_LBUTTONDOWN:
            break;
        case WM_MOUSEMOVE:
            break;
        case WM_LBUTTONUP:
            break;
    }

    // Pass unhandled messages on to WndProcDefault
    return WndProcDefault(hwnd, uMsg, wParam, lParam);
}

void CMainFrame::updateGrpView()
{
    int itemIdx = ::SendMessage(cbGroup, CB_GETCURSEL, 0, 0);
    int key = ::SendMessage(cbGroup, CB_GETITEMDATA, itemIdx, 0);
    char s[256];

    if (key)
        sprintf(s, "select * from product where product_group_id = %d order by name", key);
    else
        sprintf(s, "select * from product order by name");

    view.setQuery(s);
    view.loadData();
}

void CMainFrame::viewDblClick()
{
    int itemIdx = ::SendMessage(cbGroup, LB_GETCURSEL, 0, 0);
    if (itemIdx < 0)
        return;

    int key = ::SendMessage(cbGroup, LB_GETITEMDATA, itemIdx, 0);
    if (key)
    {
        // retrieve record
    }
}
