#ifndef FRAME_H
#define FRAME_H


#include "WinCore.h"
#include "WCEframe.h"
#include "Dialog.h"
#include "GDI.h"
#include "gps.h"


class CMainFrame : public CWceFrame
{
public:
    CMainFrame();
    virtual ~CMainFrame();
    virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
    virtual void OnInitialUpdate();

protected:
    virtual void OnPaint(HDC hDC);
    virtual LRESULT WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

private:
    GPS* gps;
    FILE* log;
    
    class GPSInfo
    {
    public:
        int timeStamp;
        wchar_t lon[12];
        wchar_t lat[12];
        float speed;
        float course;
    } gpsInfo;
    
    void startGPS();
    void updateGPS();
};

#endif   //FRAME_H
