#include "MainFrm.h"
#include "resource.h"

#include <GDI.h>
#include <math.h>
#include <aygshell.h>


CMainFrame::CMainFrame()
{
    // Set the Resource IDs for the toolbar buttons
    m_ToolbarData.clear();
    m_ToolbarData.push_back(0);         // Separator
    m_ToolbarData.push_back(IDM_FILE_EXIT);
    m_ToolbarData.push_back(IDM_EDIT_COPY);
    m_ToolbarData.push_back(IDM_EDIT_PASTE);
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
    switch (LOWORD(wParam))
    {
        case IDM_HELP_ABOUT:
        {
            CDialog HelpDialog(IDW_ABOUT, m_hWnd);
            HelpDialog.DoModal();
        }
        break;

        case IDM_EDIT_COPY:
            editBox.SendMessage(WM_COPY, 0, 0);
            break;
        case IDM_EDIT_CUT:
            editBox.SendMessage(WM_CUT, 0, 0);
            break;
        case IDM_EDIT_PASTE:
            editBox.SendMessage(WM_PASTE, 0, 0);
            break;
        case IDM_EDIT_UNDO:
            editBox.SendMessage(EM_UNDO, 0, 0);
            break;

        case IDM_FILE_NEW:
            break;
        case IDM_FILE_EXIT:
            this->SendMessage(WM_CLOSE, 0, 0);
            break;
    }

    switch (HIWORD(wParam))
    {
        case CBN_DROPDOWN:
            break;
        case CBN_CLOSEUP:
            break;
        case LBN_DBLCLK:
            break;
    }

    return 0;
}

void CMainFrame::OnInitialUpdate()
{
    CRect r = GetClientRect();

    editBox.Create(m_hWnd);
    editBox.MoveWindow(10, 26, r.Width()-20, r.Height()-36);
}

void CMainFrame::OnPaint(HDC hDC)
{
    Win32xx::GradientFill(hDC, RGB(0, 0, 128), RGB(0, 128, 255), GetViewRect(), true);
}

LRESULT CMainFrame::WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    // handle left mouse button up/down and mouse move messages
    // a seperate function for each case keeps the code tidy.
    switch (uMsg)
    {
        case WM_LBUTTONDOWN:
            break;
        case WM_MOUSEMOVE:
            break;
        case WM_LBUTTONUP:
            break;
    }

    // Pass unhandled messages on to WndProcDefault
    return WndProcDefault(hwnd, uMsg, wParam, lParam);
}

