#ifndef FRAME_H
#define FRAME_H


#include "WinCore.h"
#include "WCEframe.h"
#include "Dialog.h"
#include "GDI.h"
#include "dataprovider.h"
#include "gps.h"


class CMainFrame : public CWceFrame
{
public:
    CMainFrame();
    virtual ~CMainFrame();
    virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
    virtual void OnInitialUpdate();

protected:
    virtual void OnPaint(HDC hDC);
    virtual LRESULT WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

private:
    GPS* gps;
    FILE* simGPS;
    FILE* log;
    DataProvider* dp;
    SpeedTrap* currTrap;
    float lastD;
    bool showInfo;
    UINT timerId;
    
    class GPSInfo
    {
    public:
        int timeStamp;
        float speed;
        float course;
    } gpsInfo;
    
    void startGPS();
    void updateGPS();
    void simulateGPSInput();
    void drawSpeedTrapInfo(CDC& dc, int w);
    void setFont(CDC& dc, WCHAR* face, int ptsize, bool bold, bool italic);
    int  getIconId(int type, int speed);
};

#endif   //FRAME_H
