#include <utility>
#include <vector>

#include "database.h"

typedef enum
{
	 CT_UNKNOWN         = 0,
	 CT_DISTANCECTRL    = 1,
	 CT_DRIVEWAYCTRL    = 2,
	 CT_DUMMY           = 3,
	 CT_BUSLANECTRL     = 4,
	 CT_ENTRANCECTRL    = 5,
	 CT_SPEEDCTRL       = 6,
	 CT_WEIGHTCTRL      = 7,
	 CT_HEIGHTCTRL      = 8,
	 CT_SPEEDREDLCTRL   = 9,
	 CT_REDLIGHTCTRL    = 10,
	 CT_SECTIONCTRLST   = 11,
	 CT_SECTIONCTRLEND  = 12,
	 CT_CROSSWALKCTRL   = 13
} SpeedTrapType;

typedef enum
{
    DT_UNIDIR = 0,
    DT_BIDIR_TURN = 1
} SpeedTrapDirType;

class SpeedTrap
{
public:
    SpeedTrap()
        : id(0), longitude(0), latitude(0), type(CT_UNKNOWN), speed(0), direction(0), dirType(DT_UNIDIR)
    {
    }
    
    int getId()
    {
        return id;
    }
    
    float getLongitude()
    {
        return longitude;
    }
    
    float getLatitude()
    {
        return latitude;
    }
    
    SpeedTrapType getType()
    {
        return type;
    }
    
    int getSpeed()
    {
        return speed;
    }
    
    int getDirection()
    {
        return direction;
    }
    
    SpeedTrapDirType getDirType()
    {
        return dirType;
    }
    
private:
    friend class DataProvider;
    int id;
    float longitude;
    float latitude;
    SpeedTrapType type;
    int speed;
    int direction;
    SpeedTrapDirType dirType;
};


class DataProvider
{
public:
    static DataProvider& getInstance();
    void setLog(FILE* fl)
    {
        log = fl;
    }
    void close();
    SpeedTrap* getNearestSpeedTrap(float longitude, float latitude, float maxd, float& nd);
    
private:
    DataProvider(char* dbname);
    int bufferData(int quadId);
    
private:
    static DataProvider* instance;
    Database* db;
    FILE* log;
    
    typedef std::pair<int, std::vector<SpeedTrap>* > QuadData;
    std::vector<QuadData> cache;
};

