import java.io.*;
import java.util.Vector;

public class SpeedConv
{
    public static void main(String[] args)
    {
        if (args.length < 1)
        {
            System.err.println("Not enough input arguments");
            return;
        }
        
        try
        {
            SpeedConv app = new SpeedConv();
            app.run(args[0]);
        }
        catch (Exception x)
        {
            System.err.println(x);
        }
    }
    
    private void run(String inFileName)
        throws Exception
    {
        String line;
        SpeedCamData data = new SpeedCamData();

        BufferedReader rdr = new BufferedReader(new InputStreamReader(new FileInputStream(inFileName), 
            "ISO-8859-1"));
        
        int lnNo = 1;
        do
        {
            line = rdr.readLine();
            if (line != null)
            {
                //System.out.println("Line " + lnNo++);
                data.decode(line);
                data.outputSQL();
            }
        } while (line != null);
        
        rdr.close();
    }
    
    class SpeedCamData
    {
        private final String[] typeCode = {"AK", "AFK", "AT", "BK", "EK", "G", "GK", "HK", "GA", "A", 
            "SC", "SCE", "FGW"};
        private final String[] countryCode = {"A", "AU", "B", "CH", "CZ", "D", "ES", "FI", "FR", "GB", 
            "I", "L", "LI", "NL", "NO", "P", "PL", "SE"};
        
        public final int CT_UNKNOWN         = 0;
        public final int CT_DISTANCECTRL    = 1;
        public final int CT_DRIVEWAYCTRL    = 2;
        public final int CT_DUMMY           = 3;
        public final int CT_BUSLANECTRL     = 4;
        public final int CT_ENTRANCECTRL    = 5;
        public final int CT_SPEEDCTRL       = 6;
        public final int CT_WEIGHTCTRL      = 7;
        public final int CT_HEIGHTCTRL      = 8;
        public final int CT_SPEEDREDLCTRL   = 9;
        public final int CT_REDLIGHTCTRL    = 10;
        public final int CT_SECTIONCTRLST   = 11;
        public final int CT_SECTIONCTRLEND  = 12;
        public final int CT_CROSSWALKCTRL   = 13;
        
        private int id;         // 0
        private int speed;      // 7
        private int type;       // 8
        private int status;     // 12 { A, L, Z } -> { 1, 0, -1 } 
        private int longitude;  // 13
        private int latitude;   // 14
        private boolean checked;// 15
        private int drivingDir; // 16
        private int dirType;    // 17 { 0 - one dir, 1 - both or turnable }
        
        Vector<String> types = new Vector<String>();
        
        public SpeedCamData()
        {
            for (String s : typeCode)
                types.add(s);
        }
        
        public void decode(String line)
            throws Exception
        {
            String[] tokens = line.split(";");
            if (tokens.length < 19)
                throw new Exception("Incomplete line");
                
            id = Integer.decode(tokens[0]);
            speed = tokens[7].equals("?") || tokens[7].equals("/") || tokens[7].length() == 0 
                ? -1 : Integer.decode(tokens[7]);
            type = types.indexOf(tokens[8]) + 1;
            status = tokens[12].equals("A") ? 1 : (tokens[12].equals("L") ? 0 : -1);
            longitude = decodeWGS(tokens[13]);
            latitude = decodeWGS(tokens[14]);
            checked = tokens[15].equals("+");
            drivingDir = tokens[16].length() == 0 ? -1 : Integer.decode(tokens[16]);
            dirType = tokens[17].equals("1") ? 1 : 0;
        }
        
        private int decodeWGS(String s)
        {
            boolean neg = s.charAt(0) == '-';
            
            int dp = s.indexOf("°");
            int mp = s.indexOf("'");
            
            String degs = s.substring(0, dp);
            if (degs.charAt(0) == '0' && degs.length() > 1)
                degs = degs.substring(1);
            String mins = s.substring(dp+1, mp);
            if (mins.charAt(0) == '0')
                mins = mins.substring(1);
            String secs = s.substring(mp+1);
            //System.out.printf("D: %s, M: %s, S: %s\n", degs, mins, secs);
            int deg = Math.abs(Integer.decode(degs));
            int min = Integer.decode(mins);
            float sec = Float.parseFloat(secs);
            
            float wgs = deg + (float)min/60.0f + sec/3600.0f;
            if (neg)
                wgs = -wgs;
                
            return (int)(1e7*wgs);
        }
        
        public void outputSQL()
        {
            int quadId = ((longitude / 10000000) & 0xFFFF) | ((latitude / 10000000) << 16);
            // id, longitude, latitude, speed, type, status, direction, dir_type, quad_id
            System.out.printf("insert into speedcam values (%d, %d, %d, %d, %d, %d, %d, %d, %d);\n", 
                id, longitude, latitude, speed, type, status, drivingDir, dirType, quadId);
        }
    }
}

