#ifndef _gps_h_
#define _gps_h_

#include "commdev.h"

#define WM_GPS (WM_USER + 1)

class GPS : public CommDev
{
public:
    GPS(const char* port, int rate);
    
    void setLogFile(FILE* logFile)
    {
        log = logFile;
    }
    
    void setNotifyWindow(HWND hWnd)
    {
        notifyWindow = hWnd;
    }
    
    bool getDataValid()
    {
        return dataValid;
    }
    
    int getTimeStamp()
    {
        return lastTimestamp;
    }
    
    int getNumSatellites()
    {
        return lastNSats;
    }
    
    double getLongitude()
    {
        return lastLongitude;
    }
    
    double getLatitude()
    {
        return lastLatitude;
    }
    
    double getVelocity()
    {
        return lastVelocity;
    }
    
    double getCourse()
    {
        return lastCourse;
    }
    
    void simulateInput(char* nmeastr)
    {
        processString(nmeastr);
    }

protected:    
    virtual void processString(char* str);
    
    static DWORD WINAPI CommProc(LPVOID);
    
private:
    HWND   notifyWindow;
    FILE*  log;
    
    bool   dataValid;
    int    lastTimestamp;
    int    lastNSats;
    double lastLongitude;
    double lastLatitude;
    double lastVelocity;
    double lastCourse;
};

#endif // _gps_h_

