#include <math.h>
#include "sphericalgeometry.h"

const float SphericalGeometry::Re = 6378137.0;

float SphericalGeometry::getDistance(float l1, float b1, float l2, float b2)
{
    double dl = deg2rad(l1) - deg2rad(l2);
    double B1 = deg2rad(b1);
    double B2 = deg2rad(b2);
    
    return Re * acos(sin(B2)*sin(B1) + cos(B2)*cos(B1)*cos(dl));
}

