#include <stdio.h>
#include <textcodec.h>

#include "weatherinfo.h"

void WeatherInfo::clear()
{
    locality.clear();
    date.clear();
    time.clear();
    temperature.clear();
    condition.clear();
    humidity.clear();
}

string WeatherInfo::getAttribValue(TiXmlNode* node)
{
    char xstr[255];
    TiXmlAttribute* pAttrib = ((TiXmlElement*)node)->FirstAttribute();
    if (pAttrib)
        TextCodec::xcode(pAttrib->Value(), xstr);
    else
        strcpy(xstr, "");
    return xstr;
}

void WeatherInfo::loadForecastInfo(TiXmlNode* node, WeatherInfo& wi)
{
    const char* value = node->Value();
    if (strcmp(value, "city") == 0) 
    {
        wi.locality = getAttribValue(node);
    } 
    else if (strcmp(value, "forecast_date") == 0) {
        wi.date = getAttribValue(node);        
    } 
    else if (strcmp(value, "current_date_time") == 0) {
        wi.date = getAttribValue(node).substr(11, 5);
    } 
    else if (strcmp(value, "temp_c") == 0) {
        wi.temperature = getAttribValue(node);
    } 
    else if (strcmp(value, "condition") == 0) {
        wi.condition = getAttribValue(node);
    } 
    else if (strcmp(value, "humidity") == 0) {
        wi.humidity = getAttribValue(node);
    }
    else if (strcmp(value, "wind_condition") == 0) {
        wi.wind = getAttribValue(node);
    }
    else if (strcmp(value, "icon") == 0) {
        wi.icon = getAttribValue(node);
        int p = wi.icon.rfind("/");
        wi.icon = wi.icon.substr(p+1);
        p = wi.icon.find(".");
        wi.icon = wi.icon.substr(0, p);
    }
}

void WeatherInfo::loadRecs(TiXmlNode* node, WeatherInfo& wInfo)
{
    int type = node->Type();
    switch (type)
    {
        case TiXmlNode::DECLARATION:
            //printf("Encoding: %s\n", node->ToDeclaration()->Encoding());
            break;
        case TiXmlNode::DOCUMENT:
            //printf("Document\n");
            break;
        case TiXmlNode::TEXT:
            //printf("Text: %s\n", node->ToText()->Value());
            break;
        case TiXmlNode::ELEMENT:
            //printf("Element %s\n", node->Value());
            if (strcmp(node->Value(), "forecast_information") == 0) 
            {
                for (TiXmlNode* child = node->FirstChild(); child != 0; child = child->NextSibling())
                    loadForecastInfo(child, wInfo);
            }
            if (strcmp(node->Value(), "current_conditions") == 0) 
            {
                for (TiXmlNode* child = node->FirstChild(); child != 0; child = child->NextSibling())
                    loadForecastInfo(child, wInfo);
            }
            break;
    }
    
    for (TiXmlNode* child = node->FirstChild(); child != 0; child = child->NextSibling())
    {
        loadRecs(child, wInfo);
    }
}

bool WeatherInfo::parse(const char* fileName, WeatherInfo& wInfo)
{
    wInfo.clear();
    TiXmlDocument doc(fileName);
    bool loadOkay = doc.LoadFile();
    TextCodec::selectSourceEncoding("iso-8859-2");
    TextCodec::selectTargetEncoding("utf-8");
    if (loadOkay) 
    {
        loadRecs(&doc, wInfo);
    } 
    
    return loadOkay;
}

