#ifndef WEATHERINFO_H
#define WEATHERINFO_H

#include <tinyxml.h>
#include <string>

using std::string; 

class WeatherInfo
{
public:
    string locality;
    string date;
    string time;
    string condition;
    string icon;
    string temperature;
    string wind;
    string humidity;
    
public:
    void clear();
    static bool parse(const char* fileName, WeatherInfo& wi);
private:
    static string getAttribValue(TiXmlNode* node);
    static void loadForecastInfo(TiXmlNode* node, WeatherInfo& wi);
    static void loadRecs(TiXmlNode* node, WeatherInfo& wInfo);
};

#endif // WEATHERINFO_H

