#include <httpsocket.h>
#include <stdio.h>
#include <string>

#include "weathersource.h"

bool WeatherSource::getWeather(const char* city, const char* contentFile)
{
    HttpSocket s;
    int port = 80;
    char path[255];
    
    Socket::startup();
    int r = s.create();
    if (r)
        return false;
        
    sprintf(path, "/ig/api?weather=%s&hl=pl", city);
    r = s.connect("www.google.com", port);
    if (r)
    {
        //perror("Cannot connect");
        return false;
    }
    
    r = s.get(path);
    if (r)
    {
        //perror("Send request");
        return false;
    } 
    
    std::string resp = s.readResponse();
    FILE* fo = fopen(contentFile, "wb");
    fwrite(resp.c_str(), 1, resp.length(), fo);
    fclose(fo);
    
    Socket::shutdown();
    return true;
}
