#ifndef _SOCKET_H_
#define _SOCKET_H_

#ifdef _WIN32

  #include <winsock.h>

  #define sock_getlasterror() WSAGetLastError()

#else

  #include <arpa/inet.h>
  #include <errno.h>
  #include <sys/socket.h>
  #include <sys/time.h>
  #include <sys/types.h>
  #include <netdb.h>
  #include <netinet/in.h>
  #include <unistd.h>
  #include <stdlib.h>
  #include <string.h>

  #define SOCKET int
  #define INVALID_SOCKET 0
  #define SOCKET_ERROR  -1
  #define sock_getlasterror() errno
  #define closesocket(s) close((s))

  typedef struct sockaddr_in SOCKADDR_IN;

#endif

class Socket
{
public:
    Socket();
    ~Socket();
    
    int create(int type = SOCK_STREAM, short port = 0);
    int bind(const char* targetAddr, short port);
    int connect(const char* targetAddr, short port);
    void disconnect();
    int read(char* buff, unsigned size, int flags = 0);
    int write(const char *buff, unsigned size) const;
    int puts(const char *str) const;
    
    operator SOCKET() const
    {
        return s;
    }
    
    static int startup();
    static int shutdown();
protected:
    SOCKET s;
};


#endif // _SOCKET_H_

