#ifndef __STRTOOL_H__
#define __STRTOOL_H__

#include <stdio.h>
#include <string.h>
#include <wchar.h>
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#ifdef HAVE_UNICODE_H
#include <unicode.h>
#endif

typedef unsigned short uchar16_t;
typedef unsigned uint32_t;

class StrTool
{
public:
    /**
    * function new_str
    * @s:  pointer to string to process
    * @l:  optional length of string; if 0 the whole string is taken
    *
    * duplicate the string using new operator to allocate memory
    *
    * Returns the duplicated string
    */
    static char* new_str(const char* s, int l = 0);
    /**
    * the same for utf16
    */
    wchar_t* new_str(const wchar_t* s, int l = 0);
    
    /**
    * function tokenize
    * @s:  pointer to string to process
    * @sep:  separator character
    * @count:  pointer to the count of returned tokens
    *
    * Tokenize a character string separated by specified character
    *
    * Returns the array of tokens; some tokens may be NULL!!!
    */
    static char** tokenize(char* s, char sep, int* count);
    
    /**
    * function tokenize
    * @s:  pointer to string to process
    * @sep:  separator character
    * @tokens:  pointer to an array receving tokenization result
    * @maxt:  max number of items in the token array
    *
    * Tokenize a character string separated by specified character
    *
    * Returns the number tokens or -1 if maxt is too small
    */
    static int tokenize(char* s, char sep, char** tokens, int maxt);
    
    /**
    * function levenshtein
    * @str1: pointer to string1
    * @str2: pointer to string2
    * @confLevel: confidence level is returned instead of the cost (default)
    *
    * Calculate the distnace between 2 strings
    * Returns the cost (distance) or confidence level
    */
    static int levenshtein(const char *str1, const char *str2, bool confLevel = true);
    
    /**
    * function utf8ToUtf16, utf8ToUtf16Lower
    * @out:  a pointer to an array of shorts to store the result
    * @outlen:  the length of @out (number of shorts)
    * @in:  a pointer to an array of UTF-8 chars
    * @inlen:  the length of @in
    *
    * Take a block of UTF-8 chars in and try to convert it to an UTF-16
    * block of chars out.
    *
    * Returns the number of characters written, or -1 by lack of space, or -2
    *     if the transcoding failed.
    */
    static int utf8ToUtf16(wchar_t* out, int outlen, unsigned char* in, int inlen = 0);
    static int utf8ToUtf16(uchar16_t* out, int outlen, unsigned char* in, int inlen = 0);
    
    static int utf8ToUtf16Lower(wchar_t* out, int outlen, unsigned char* in, int inlen);
    
    static int u16CharToUtf8(unsigned ucode, char* uc);
    static int utf16ToUtf8(char* u8s, const uchar16_t* u16s);
    
    static void wcsupr(wchar_t* ws);
    static void wcslwr(wchar_t* ws);
};

#endif // __STRTOOL_H__
