/**
 *   \file               sharedmem.h
 *   \brief              Definition of class for named shared memory blocks
 *   \version            \$Revision$
 *   \par Last commit:
 *                       \$Date$ by \n
 *                       \$Author$
 *   \par Copyright:
 *                       MC \n
 *   \par Notes:
 *
 */

#ifndef SHARED_MEMORY_H
#define SHARED_MEMORY_H

#if defined(_WIN32) || defined(_WIN32_WINCE)
#include <windows.h>
#endif


namespace System
{

/**
 *  \brief Class implementing named shared memory blocks
 */
class SharedMemory
{
public:
    /**
     *  \brief Default constructor
     */
    SharedMemory();

    /**
     *  \brief Destructor
     */
    ~SharedMemory();

    /**
     *  \brief Creates shared memory block of given size, identified by name
     *  \param size - size of shared memory in bytes
     *  \param name - name of the shared memory object
     *  \param writeAccess - true (default) if write access is desired
     *  \throw std::runtime_error if shared memory cannot be created
     */
    void create(unsigned size, const char* name, bool writeAccess = true);

    /**
     *  \brief Returns the pointer to shared memory block
     *  \return Pointer to the memory block or NULL if create has not been called or failed
     */
    unsigned char* getPointer();

private:
    /**
     * \brief Hidden copy constructor to avoid incidental copying of shared memory objects
     */
    SharedMemory(SharedMemory const&);

    /**
     * \brief Hidden assignment operator to avoid incidental copying of shared memory objects
     */
    SharedMemory& operator = (SharedMemory const&);

    /**
     *  \brief block size
     */
    unsigned m_size;

#if defined(_WIN32)
    /**
     *  \brief Windows: handle to mapping object
     */
    HANDLE m_mapObject;
#else
    /**
     *  \brief Linux: file handle
     */
    int m_fId;
#endif

    /**
     *  \brief pointer to created memory block
     */
    unsigned char* m_ptr;
};

} // namespace System

#endif // SHARED_MEMORY_H
