//------------------------------------------------------------------------------
// Nazwa pliku: dwawejscia.h
// Copyright (c) 2009, Instytut Elektroniki PL & Piotr M. Szczypinski
//------------------------------------------------------------------------------

#ifndef _DWAWEJ_H_
#define _DWAWEJ_H_
//------------------------------------------------------------------------------
// Identyfikator GUID filtru musi byc unikatowy dla kazdego filtru.
// Aby zapewnic unikatowosc nalezy generowac identyfikatory za pomoca
// programem GuidGen.exe
//------------------------------------------------------------------------------
// {3D750395-7696-42cf-A4A0-3FC7DF65CB2F}
DEFINE_GUID(CLSID_VDwaWej,
	0x3d750395, 0x7696, 0x42cf, 0xa4, 0xa0, 0x3f, 0xc7, 0xdf, 0x65, 0xcb, 0x2f);

//------------------------------------------------------------------------------
// Klasa CVTwoInpRIn implementuje prawe wyprowadzenie wejsciowe filtru.
// Dziedziczy ona z klasy bazowej DirectShow - CTransformInputPin.
//------------------------------------------------------------------------------
class CVTwoInpRIn : public CTransformInputPin
{
public:
	// Konstruktor wyprowadzenia wyjsciowego filtru
	CVTwoInpRIn(
		TCHAR *pObjectName,
		CTransformFilter *pTransformFilter,
		HRESULT * phr,
		LPCWSTR pName);
	// Funkcja odbiera i przeyla do filtru obraz
	STDMETHODIMP Receive(IMediaSample *pSample);
	// Funkcja zwraca nazwe identyfikacyjna wyprowadzenia
	STDMETHODIMP QueryId(LPWSTR * Id)
	{
		return AMGetWideString(L"InR", Id);
	}
};

//------------------------------------------------------------------------------
// Klasa CVTwoInpLIn implementuje lewe wyprowadzenie wejsciowe filtru.
// Dziedziczy ona z klasy bazowej DirectShow - CTransformInputPin.
//------------------------------------------------------------------------------
class CVTwoInpLIn : public CTransformInputPin
{
public:
	// Konstruktor wyprowadzenia wyjsciowego filtru
	CVTwoInpLIn(
		TCHAR *pObjectName,
		CTransformFilter *pTransformFilter,
		HRESULT * phr,
		LPCWSTR pName);
	// Funkcja zwraca nazwe identyfikacyjna wyprowadzenia
	STDMETHODIMP QueryId(LPWSTR * Id)
	{
		return AMGetWideString(L"InL", Id);
	}
};

//------------------------------------------------------------------------------
class CFiltrDwaWejscia : public CTransformFilter
{

public:
	~CFiltrDwaWejscia();
	static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);
	HRESULT ReceiveR(IMediaSample *pSample);
	HRESULT StartStreaming();
	HRESULT StopStreaming();

	// Transform odbiera obraz z wejscia lewego. 
	// Odpowiada za synchronizacje czasowa z prawym obrazem	
	HRESULT Transform(IMediaSample *pIn, IMediaSample *pOut);
	// TransformR odbiera obraz z wejscia prawego. 
	// Pozwala na wstrzymanie watku do momentu nadejscia obrazu prawego.	
	HRESULT TransformR(IMediaSample *pIn);

	HRESULT CheckInputType(const CMediaType *mtIn);
	HRESULT CheckTransform(const CMediaType *mtIn,const CMediaType *mtOut);
	HRESULT GetMediaType(int iPosition, CMediaType *pMediaType);
	HRESULT DecideBufferSize(IMemAllocator *pAlloc,
		ALLOCATOR_PROPERTIES *pProperties);
	int GetPinCount(void);
	CBasePin * GetPin(int n);
	STDMETHODIMP FindPin(LPCWSTR Id, IPin **ppPin);

	// Funkcja odblokowuje watki lewego i prawego obrazu. 
	// Przekazuje komende BeginFlush do nastepnego filtra.
	HRESULT BeginFlush(void);

	// Przekazuje komende EndFlush do nastepnego filtra.
	HRESULT EndFlush(void);
private:
	int m_Height;                 
	int m_Width;   
	int m_Bits;  

	CVTwoInpRIn* m_pInputR;
	IMediaSample * pRightSample;

	// Obiekty synchronizacji watkow dla lewego i prawego obrazu.
	// Wykorzystywane przez funkcje Transform i TransformR.
	HANDLE ghLeftEvent;
	HANDLE ghRightEvent;
	bool m_bFlushinghere;
	CFiltrDwaWejscia(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	HRESULT InitializeOutSample(IMediaSample *pSource, IMediaSample *pDest) const;

	// Glowna funkcja przetwarzania. 
	// Otrzymuje lewy (pLIn) i prawy (pRIn) obraz, 
	// zwraca obraz wynikowy w obiekcie wskazanym przez pOut. 
	HRESULT MergeImages(IMediaSample *pLIn, IMediaSample *pRIn, IMediaSample *pOut) const;
};
#endif //_DWAWEJ_H_
