//--------------------------------------------------------------------------------------
//  Plik Wideo24cv.cpp
//  Filtr "w miejscu" dokonuje zmian w obrazie, 
//  ktory jest jednoczesnie obrazem wejsciowym i wyjsciowym
//  Autor: Piotr M. Szczypinski
//  2009.01.05
//  Instytut Elektroniki Politechniki Ldzkiej
//--------------------------------------------------------------------------------------

// Program wzorowany na przykladzie "null in place" firmy Microsoft

#include <streams.h>    
#include <initguid.h>
#include "wideo24.h"    

//--------------------------------------------------------------------------------------
// Numer CLSID/GUID filtru wygenerowany przez program GuidGen
// {E0A7B8FF-A9DB-41b4-8FFF-1BC668D74691}
DEFINE_GUID(CLSID_wideo24, 
			0xe0a7b8ff, 0xa9db, 0x41b4, 0x8f, 0xff, 0x1b, 0xc6, 0x68, 0xd7, 0x46, 0x91);


//--------------------------------------------------------------------------------------
// Dane potrzebne do utworzenia filtru i jego wyprowadzen
const AMOVIESETUP_MEDIATYPE
sudPinTypes =   { &MEDIATYPE_NULL                // clsMajorType
, &MEDIASUBTYPE_NULL }  ;       // clsMinorType

const AMOVIESETUP_PIN
psudPins[] = { { L"Input"            // strName
, FALSE               // bRendered
, FALSE               // bOutput
, FALSE               // bZero
, FALSE               // bMany
, &CLSID_NULL         // clsConnectsToFilter
, L"Output"           // strConnectsToPin
, 1                   // nTypes
, &sudPinTypes }      // lpTypes
, { L"Output"           // strName
, FALSE               // bRendered
, TRUE                // bOutput
, FALSE               // bZero
, FALSE               // bMany
, &CLSID_NULL         // clsConnectsToFilter
, L"Input"            // strConnectsToPin
, 1                   // nTypes
, &sudPinTypes } };   // lpTypes


const AMOVIESETUP_FILTER
sudNullIP = { &CLSID_wideo24                  // clsID
, L"KL_WIDEO24"                    // strName
, MERIT_DO_NOT_USE                // dwMerit
, 2                               // nPins
, psudPins };                     // lpPin

//--------------------------------------------------------------------------------------
// Potrzebne podczas wykonania CreateInstance
CFactoryTemplate g_Templates[]=
{   {L"KL_WIDEO24"
, &CLSID_wideo24
, CFiltrWideo24::CreateInstance
, NULL
, &sudNullIP }

};
int g_cTemplates = sizeof(g_Templates)/sizeof(g_Templates[0]);


//--------------------------------------------------------------------------------------
// Konstuktor klasy
CFiltrWideo24::CFiltrWideo24(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr)
: CTransInPlaceFilter (tszName, punk, CLSID_wideo24, phr)
{

} // (CNullInPlace constructor)


//--------------------------------------------------------------------------------------
// Tworzy obiekt COM filtru Zielenina
CUnknown * WINAPI CFiltrWideo24::CreateInstance(LPUNKNOWN punk, HRESULT *phr) 
{
	ASSERT(phr);

	CFiltrWideo24 *pNewObject = new CFiltrWideo24(NAME("KL_Wideo24"), punk, phr );
	if(pNewObject == NULL) 
		if(phr)
			*phr = E_OUTOFMEMORY;

	return pNewObject;

}

//--------------------------------------------------------------------------------------
// Funkcja wywolywana przez piny podczas negocjacji rodzaju transmisji
// Akceptowany format transmisja to nieskompreowane wideo 24 bity na piksel.
HRESULT CFiltrWideo24::CheckInputType(const CMediaType* mtIn) 
{

	if(*mtIn->FormatType() != FORMAT_VideoInfo) return VFW_E_TYPE_NOT_ACCEPTED;
	if(!(IsEqualGUID(*mtIn->Type(), MEDIATYPE_Video))) return VFW_E_TYPE_NOT_ACCEPTED;

	if(IsEqualGUID(*mtIn->Subtype(), MEDIASUBTYPE_RGB24))
	{
		VIDEOINFO *pvi = (VIDEOINFO *) mtIn->Format();
		if (pvi->bmiHeader.biBitCount != 24) 
		{	
			return VFW_E_TYPE_NOT_ACCEPTED;
		}
		return S_OK;
	} 
	return VFW_E_TYPE_NOT_ACCEPTED;
}

//--------------------------------------------------------------------------------------
// Funkcja wywolywana do transformowania probki (tutaj klatki obrazu)
HRESULT CFiltrWideo24::Transform(IMediaSample *pSample)
{
	BYTE *pData;                
	long lDataLen;              
	int x, y;  
	RGBTRIPLE *prgb;            

	AM_MEDIA_TYPE* pType = &m_pInput->CurrentMediaType();
	VIDEOINFOHEADER *pvi = (VIDEOINFOHEADER *) pType->pbFormat;
	ASSERT(pvi);

	CheckPointer(pSample,E_POINTER);
	pSample->GetPointer(&pData);
	lDataLen = pSample->GetSize();

	int width     = pvi->bmiHeader.biWidth;
	int height = abs(pvi->bmiHeader.biHeight);
	int bits     = pvi->bmiHeader.biBitCount;
	int stride     = (width * sizeof( RGBTRIPLE ) + 3) & -4;
	int pixels  = width * height;

	for (y = 0; y < height; y++)
	{
		for (x = 0; x < width; x++) 
		{
			prgb = (RGBTRIPLE*) (pData + stride * y + sizeof(RGBTRIPLE)*x);
			// Tu nalezy wpisywac kod zmieniajacy piksel po pikselu

			// Przyklad: zamiana kolorow
			/*
			BYTE g = prgb->rgbtGreen;
			prgb->rgbtGreen = prgb->rgbtBlue;
			prgb->rgbtBlue = prgb->rgbtRed;
			prgb->rgbtRed = g;
			*/
			// Przyklad: negatyw
			prgb->rgbtGreen = 255 - prgb->rgbtGreen;
			prgb->rgbtBlue = 255 - prgb->rgbtBlue;
			prgb->rgbtRed = 255 - prgb->rgbtRed;

			// Przyklad: przepusc skladowa zielona
			/*
			prgb->rgbtBlue = 0;
			prgb->rgbtRed = 0;
			*/
		}
	}
	return NOERROR;
}


//--------------------------------------------------------------------------------------
// Funkcje wywolywane podczas rejestracji filtru przez program RegSvr32
STDAPI DllRegisterServer()
{
	return AMovieDllRegisterServer2( TRUE );
}

STDAPI DllUnregisterServer()
{
	return AMovieDllRegisterServer2( FALSE );
}


//--------------------------------------------------------------------------------------
// Funkcje niezbedne w bibliotece DLL
extern "C" BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);

BOOL APIENTRY DllMain(HANDLE hModule, 
					  DWORD  dwReason, 
					  LPVOID lpReserved)
{
	return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}


