//--------------------------------------------------------------------------------------
//  Plik Wideo24cv.cpp
//  Filtr "w miejscu" dokonuje zmian w obrazie, 
//  ktory jest jednoczesnie obrazem wejsciowym i wyjsciowym
//  Autor: Piotr M. Szczypinski
//  2009.01.05
//  Instytut Elektroniki Politechniki Ldzkiej
//--------------------------------------------------------------------------------------

// Program wzorowany na przykladzie "null in place" firmy Microsoft

#include <streams.h>    
#include <initguid.h>
#include <cv.h>    //from openCV
#include "wideo24cv.h"    

//--------------------------------------------------------------------------------------
// Numer CLSID/GUID filtru wygenerowany przez program GuidGen
// {E106734B-D7DF-4a12-B91A-40D3F4687732}
DEFINE_GUID(CLSID_wideo24, 
0xe106734b, 0xd7df, 0x4a12, 0xb9, 0x1a, 0x40, 0xd3, 0xf4, 0x68, 0x77, 0x32);


//--------------------------------------------------------------------------------------
// Dane potrzebne do utworzenia filtru i jego wyprowadzen
const AMOVIESETUP_MEDIATYPE
sudPinTypes =   { &MEDIATYPE_NULL                // clsMajorType
                , &MEDIASUBTYPE_NULL }  ;       // clsMinorType

const AMOVIESETUP_PIN
psudPins[] = { { L"Input"            // strName
               , FALSE               // bRendered
               , FALSE               // bOutput
               , FALSE               // bZero
               , FALSE               // bMany
               , &CLSID_NULL         // clsConnectsToFilter
               , L"Output"           // strConnectsToPin
               , 1                   // nTypes
               , &sudPinTypes }      // lpTypes
             , { L"Output"           // strName
               , FALSE               // bRendered
               , TRUE                // bOutput
               , FALSE               // bZero
               , FALSE               // bMany
               , &CLSID_NULL         // clsConnectsToFilter
               , L"Input"            // strConnectsToPin
               , 1                   // nTypes
               , &sudPinTypes } };   // lpTypes


const AMOVIESETUP_FILTER
sudNullIP = { &CLSID_wideo24                  // clsID
            , L"KL_WIDEO24_CV"                    // strName
            , MERIT_DO_NOT_USE                // dwMerit
            , 2                               // nPins
            , psudPins };                     // lpPin

//--------------------------------------------------------------------------------------
// Potrzebne podczas wykonania CreateInstance
CFactoryTemplate g_Templates[]=
    {   {L"KL_WIDEO24_CV"
        , &CLSID_wideo24
        , CFiltrWideo24::CreateInstance
        , NULL
        , &sudNullIP }
    
    };
int g_cTemplates = sizeof(g_Templates)/sizeof(g_Templates[0]);


//--------------------------------------------------------------------------------------
// Konstuktor klasy
CFiltrWideo24::CFiltrWideo24(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr)
    : CTransInPlaceFilter (tszName, punk, CLSID_wideo24, phr)
{

} // (CNullInPlace constructor)


//--------------------------------------------------------------------------------------
// Tworzy obiekt COM filtru Zielenina
CUnknown * WINAPI CFiltrWideo24::CreateInstance(LPUNKNOWN punk, HRESULT *phr) 
{
    ASSERT(phr);
    
    CFiltrWideo24 *pNewObject = new CFiltrWideo24(NAME("KL_Wideo24_cv"), punk, phr );
    if(pNewObject == NULL) 
        if(phr)
            *phr = E_OUTOFMEMORY;

    return pNewObject;

}

//--------------------------------------------------------------------------------------
// Funkcja wywolywana przez piny podczas negocjacji rodzaju transmisji
// Akceptowany format transmisja to nieskompreowane wideo 24 bity na piksel.
HRESULT CFiltrWideo24::CheckInputType(const CMediaType* mtIn) 
{

		if(*mtIn->FormatType() != FORMAT_VideoInfo) return VFW_E_TYPE_NOT_ACCEPTED;
    if(!(IsEqualGUID(*mtIn->Type(), MEDIATYPE_Video))) return VFW_E_TYPE_NOT_ACCEPTED;
   
    if(IsEqualGUID(*mtIn->Subtype(), MEDIASUBTYPE_RGB24))
    {
        VIDEOINFO *pvi = (VIDEOINFO *) mtIn->Format();
        if (pvi->bmiHeader.biBitCount != 24) 
				{	
					return VFW_E_TYPE_NOT_ACCEPTED;
				}
        return S_OK;
    } 
    return VFW_E_TYPE_NOT_ACCEPTED;
}

//--------------------------------------------------------------------------------------
// Funkcja wywolywana do transformowania probki (tutaj klatki obrazu)
HRESULT CFiltrWideo24::Transform(IMediaSample *pSample)
{

		BYTE *pData;                
    long lDataLen;              

// IplImage ma format naglowka obrazu akceptowany przez OpenCV
	  IplImage image;

    AM_MEDIA_TYPE* pType = &m_pInput->CurrentMediaType();
    VIDEOINFOHEADER *pvi = (VIDEOINFOHEADER *) pType->pbFormat;
    ASSERT(pvi);

    CheckPointer(pSample,E_POINTER);
    pSample->GetPointer(&pData);
    lDataLen = pSample->GetSize();

    int width     = pvi->bmiHeader.biWidth;
    int height = abs(pvi->bmiHeader.biHeight);
    int bits     = pvi->bmiHeader.biBitCount;
    int stride     = (width * sizeof( RGBTRIPLE ) + 3) & -4;
		int pixels  = width * height;

// Tlumaczy obraz z formatu DirectShow (IMediaSample)
// na format OpenCV (IplImage)
		cvInitImageHeader( &image, cvSize(width, height), 8, 3, IPL_ORIGIN_BL, 4 );
		image.widthStep = stride;
		cvSetData( &image, pData, stride );


// Przyklad: zamiana na czarno-bialy
		IplImage* gray;
		gray = cvCreateImage(cvSize(width, height), IPL_DEPTH_8U, 1);
		cvCvtColor(&image, gray, CV_BGR2GRAY);
		cvCvtColor(gray, &image, CV_GRAY2BGR);
		cvReleaseImage(&gray);

    return NOERROR;
}


//--------------------------------------------------------------------------------------
// Funkcje wywolywane podczas rejestracji filtru przez program RegSvr32
STDAPI DllRegisterServer()
{
    return AMovieDllRegisterServer2( TRUE );
}

STDAPI DllUnregisterServer()
{
     return AMovieDllRegisterServer2( FALSE );
}


//--------------------------------------------------------------------------------------
// Funkcje niezbedne w bibliotece DLL
extern "C" BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);

BOOL APIENTRY DllMain(HANDLE hModule, 
                      DWORD  dwReason, 
                      LPVOID lpReserved)
{
	return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}


