﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using OpenNETCF.Net.NetworkInformation;
using OpenNETCF.Configuration;
using OpenNETCF.WindowsCE;
namespace WLanStatictisc
{
    public partial class Form1 : Form
    {
        private delegate int listDelegate(string text);
        private delegate void textBoxDelegate(string text);


        public WLAN wifi;
        public IPv4InterfaceStatistics ipStat;
        public WirelessNetworkInterface wzc;
        TcpStatistics TCPstat = null;
        Statistics statistics;
        Settings settings;
        public Form1()
        {
            InitializeComponent();
            settings = new Settings();
            statistics = new Statistics(this,settings);
            MyTimer.isTime += this.updateGUI;


            #region MyRegion
            /*
            wifi = new WLAN();
            wifi.findNetworkNics();
            listBox1.Items.Add("dziala");
            foreach (INetworkInterface netWorkInterface in wifi.networkNics)
            {
                listBox1.Items.Add(netWorkInterface.Name);
                if (netWorkInterface is WirelessZeroConfigNetworkInterface) listBox1.Items.Add("!");
            }

            wzc = wifi.WZCInterface;
            ipStat = wzc.GetIPv4Statistics();

            listBox1.Items.Add("UnicastPacketsSent" + ipStat.UnicastPacketsSent.ToString());
            listBox1.Items.Add("UnicastPacketsReceived" + ipStat.UnicastPacketsReceived.ToString());
            listBox1.Items.Add("BytesReceived" + ipStat.BytesReceived.ToString());
            listBox1.Items.Add("BytesSent" + ipStat.BytesSent.ToString());

            IPGlobalProperties properties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = properties.GetTcpIPv4Statistics();

            listBox1.Items.Add("SegmentsSent" + TCPstat.SegmentsSent);

            wifi.WZCInterface.GetIPv4Statistics(); 
            */
            #endregion
            #region MyRegion


            /*string[] args = new string[2];
            args[0] = "192.168.1.1";
            args[1] = "public"; 

            int commlength, miblength, datatype, datalength, datastart;
            int uptime = 0;
            string output;
            SNMP conn = new SNMP();
            byte[] response = new byte[1024];
            Console.WriteLine("Device SNMP information:");
            // Send sysName SNMP request and get the response
            response = conn.get("get", "192.168.1.1", "public", "1.3.6.1.2.1.1.5.0");
            if (response[0] == 0xff)
            {
                listBox1.Items.Add("No response from " +  args[0].ToString());
                return;
            }
            // Get the community name and MIB lengths from the packet
            commlength = Convert.ToInt16(response[6]);
            miblength = Convert.ToInt16(response[23 + commlength]);
            // Extract the MIB data from the SNMP response
            datatype = Convert.ToInt16(response[24 + commlength + miblength]);
            datalength = Convert.ToInt16(response[25 + commlength + miblength]);
            datastart = 26 + commlength + miblength;
            output = Encoding.ASCII.GetString(response, datastart, datalength);
            Console.WriteLine(" sysName - Datatype: {0}, Value: {1}",
                datatype, output);
            // Send a sysLocation SNMP request
            response = conn.get("get", "192.168.1.1", "public", "1.3.6.1.2.1.1.6.0");
            if (response[0] == 0xff)
            {
                listBox1.Items.Add("No response from "+  args[0].ToString());
                return;
            }
            // Get the community name and MIB lengths from the response
            commlength = Convert.ToInt16(response[6]);
            miblength = Convert.ToInt16(response[23 + commlength]);
            // Extract the MIB data from the SNMP response
            datatype = Convert.ToInt16(response[24 + commlength + miblength]);
            datalength = Convert.ToInt16(response[25 + commlength + miblength]);
            datastart = 26 + commlength + miblength;
            output = Encoding.ASCII.GetString(response, datastart, datalength);
            Console.WriteLine(" sysLocation - Datatype: {0}, Value: {1}",
              datatype, output);
            // Send a sysContact SNMP request
            response = conn.get("get", "192.168.1.1", "public", "1.3.6.1.2.1.1.4.0");
            if (response[0] == 0xff)
            {
                listBox1.Items.Add("No response from " + args[0].ToString());
                return;
            }
            // Get the community and MIB lengths
            commlength = Convert.ToInt16(response[6]);
            miblength = Convert.ToInt16(response[23 + commlength]);
            // Extract the MIB data from the SNMP response
            datatype = Convert.ToInt16(response[24 + commlength + miblength]);
            datalength = Convert.ToInt16(response[25 + commlength + miblength]);
            datastart = 26 + commlength + miblength;
            output = Encoding.ASCII.GetString(response, datastart, datalength);
            listBox1.Items.Add(" sysContact - Datatype: , Value: " + 
                datatype.ToString() + " "+  output.ToString());

            // Send a SysUptime SNMP request
            response = conn.get("get", "192.168.1.1", "public", "1.3.6.1.2.1.1.3.0");
            if (response[0] == 0xff)
            {
                listBox1.Items.Add("No response from " + args[0].ToString());
                return;
            }
            // Get the community and MIB lengths of the response
            commlength = Convert.ToInt16(response[6]);
            miblength = Convert.ToInt16(response[23 + commlength]);
            // Extract the MIB data from the SNMp response
            datatype = Convert.ToInt16(response[24 + commlength + miblength]);
            datalength = Convert.ToInt16(response[25 + commlength + miblength]);
            datastart = 26 + commlength + miblength;
            // The sysUptime value may by a multi-byte integer
            // Each byte read must be shifted to the higher byte order
            while (datalength > 0)
            {
                uptime = (uptime << 8) + response[datastart++];
                datalength--;
            }
            listBox1.Items.Add(" sysUptime - Datatype:  Value: "+datatype.ToString() + " " +  uptime.ToString());
            */
            #endregion
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            MyTimer.stopTimer();
            Application.Exit();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            #region MyRegion
            //wifi.findNetworkNics();
            //wzc = wifi.WZCInterface;
            /*
            ipStat = wzc.GetIPv4Statistics();
            listBox1.Items.Clear();
            listBox1.Items.Add("UnicastPacketsSent" + ipStat.UnicastPacketsSent.ToString());
            listBox1.Items.Add("UnicastPacketsReceived" + ipStat.UnicastPacketsReceived.ToString());
            listBox1.Items.Add("BytesReceived" + ipStat.BytesReceived.ToString());
            listBox1.Items.Add("BytesSent" + ipStat.BytesSent.ToString());

            listBox1.Items.Add("SegmentsSent" + TCPstat.SegmentsSent);
             */
            
            #endregion

            statistics.callibrateSettings();
            MyTimer.startTimer();

        }
        public void updateListBox1(string s)
        {
            listDelegate listbox1delegate = new listDelegate(listBox1.Items.Add);
            this.Invoke(listbox1delegate, new object[] { s });
            try
            {
                this.Refresh();
                listBox1.TopIndex = listBox1.Items.Count - 3;
            }
            catch (Exception e)
            {
            }
        }

        public void updateTextBox(TextBox textBox, string s)
        {
            textBoxDelegate textBoxDelegate = delegate(string text) { textBox.Text = text; };
            this.Invoke(textBoxDelegate, new object[] { s });
            
                
        }

        private void buttonStopContinue_Click(object sender, EventArgs e)
        {
            MyTimer.stopTimer();
        }

        public void updateGUI(object sender, EventArgs args)
        {
            #region IPUpdate
            updateTextBox(textBoxIpUPR, statistics.getIPunicastPacketReceived().ToString());
            updateTextBox(textBoxIpUPS, statistics.getIPunicastPacketSent().ToString());
            updateTextBox(textBoxIPNUPS, statistics.getIPNonUnicastPacketSend().ToString());
            updateTextBox(textBoxIPNUPR, statistics.getIPunicastPacketReceived().ToString());
            updateTextBox(textBoxIPOPD, statistics.getIPOutgoingPacketsDiscarder().ToString());
            updateTextBox(textBoxIPOPWE, statistics.getIPOutgoingPacketsWithErrors().ToString());
            updateTextBox(textBoxIPIPD, statistics.getIPIncomingPacketsDiscarded().ToString());
            updateTextBox(textBoxIPIPWE, statistics.getIPIncomingPacketsWithErrors().ToString());
            updateTextBox(textBoxIPOPWNR, statistics.getIPOutgingPacketsWithNoRoute().ToString());
            #endregion

            #region TCPUpdate

            updateTextBox(textBoxTCPCurrentConnectionsNumber, statistics.getTCPCurrentConnectionsNumber().ToString());
            updateTextBox(textBoxTCPErrorsReceived, statistics.getTCPErrorsReceived().ToString());
            updateTextBox(textBoxTCPSegmentsReceived, statistics.getTCPSegmentsReceived().ToString());
            updateTextBox(textBoxTCPSegmentsResent, statistics.getTCPSegmentsResent().ToString());
            updateTextBox(textBoxTCPSegmentsSent, statistics.getTCPSegmentsSent().ToString());
            #endregion

            #region UDPUPdate
            updateTextBox(textBoxUDPDatagramsReceived, statistics.getUDPDatagramsReceived().ToString());
            updateTextBox(textBoxUDPDatagramsSent, statistics.getUDPDatagramsSent().ToString());
            updateTextBox(textBoxUDPIncomingDatagramsDiscarded, statistics.getUDPIncomingDatagramsDiscarded().ToString());
            updateTextBox(textBoxUDPIncomingDatagramsWithErrors, statistics.getUDPIncomingDatagramsWithErrors().ToString());
            #endregion

            #region RadioUPdate
            updateTextBox(textBoxSignalStrength, statistics.getSignalStrength().ToString());
            updateTextBox(textBoxFrequency, statistics.getFrequency().ToString());
            updateTextBox(textBoxFrequencyHopPattern, statistics.getFrequencyHopPattern().ToString());
            updateTextBox(textBoxFrequencyHopSet, statistics.getFrequencyHopSet().ToString());
            updateTextBox(textBoxBeaconPeriod, statistics.getBeaconPeriod().ToString());
            updateTextBox(textBoxATIMWindow, statistics.getATIMWindow().ToString());
            #endregion
        }

        private void labelIPSP_ParentChanged(object sender, EventArgs e)
        {

        }

        private void label2_ParentChanged(object sender, EventArgs e)
        {

        }

        private void labelUDPIncomingDatagramsWithErrors_ParentChanged(object sender, EventArgs e)
        {

        }

        private void labelUDPIncomingDatagramsDiscarded_ParentChanged(object sender, EventArgs e)
        {

        }
    }
}