﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using OpenNETCF.Net.NetworkInformation;
using OpenNETCF.Configuration;
using OpenNETCF.WindowsCE;

namespace WLanStatictisc
{
    class Statistics
    {

        private WLAN wifi;
        private IPv4InterfaceStatistics ipStatV4;
        private WirelessNetworkInterface wzc;
        private IPGlobalProperties IpProperties;
        private IPGlobalStatistics iPstat = null;
        private Settings settings;
        private TcpStatistics TCPstat = null;
        private UdpStatistics UDPStat = null;


        private Form1 myForm1;


        public Statistics(Form1 _myForm1, Settings _settings)
        {
            settings = _settings;
            myForm1 = _myForm1;
            wifi = new WLAN();
            wifi.findNetworkNics();
            myForm1.updateListBox1("dziala");
            foreach (INetworkInterface netWorkInterface in wifi.networkNics)
            {
                myForm1.updateListBox1(netWorkInterface.Name);
                if (netWorkInterface is WirelessZeroConfigNetworkInterface) myForm1.updateListBox1("!");
            }
            wzc = wifi.WZCInterface;
        }

        public void callibrateSettings()
        {
            settings.IncomingPacketsDiscarded = getIPIncomingPacketsDiscarded();
            settings.longIncomingPacketsWithErrors = getIPIncomingPacketsWithErrors();
            settings.nonUnicastPacketsReceived = getIPNonUnicastPacketReceived();
            settings.nonUnicastPacketsSent = getIPNonUnicastPacketSend();
            settings.outgoingPacketsDiscarded = getIPOutgoingPacketsDiscarder();
            settings.outgoingPacketsWithErrors = getIPOutgoingPacketsWithErrors();
            settings.outputPacketsWithNoRoute = getIPOutgingPacketsWithNoRoute();
            settings.unicastPacketsReceived = getIPunicastPacketReceived();
            settings.unicastPacketsSent = getIPunicastPacketSent();
            
            settings.TCPsegmentReceived = getTCPSegmentsReceived();
            settings.TCPSegmentSent = getTCPSegmentsSent();
            settings.TCPSegmentReSent = getTCPSegmentsResent();
            settings.TCPCurrentConnectionsNumber = getTCPCurrentConnectionsNumber();
            settings.TCPErrorsReceived = getTCPErrorsReceived();

            settings.UDPDatagramsReceived = getUDPDatagramsReceived();
            settings.UDPDatagramsSent = getUDPDatagramsSent();
            settings.UDPIncomingDatagramsDiscarded = getUDPIncomingDatagramsDiscarded();
            settings.UDPIncomingDatagramsWithErrors = getUDPIncomingDatagramsWithErrors();


        }



        #region IP section
        public long getBytesReceived()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.BytesReceived;
        }
        public long getIPunicastPacketReceived()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.UnicastPacketsReceived - settings.unicastPacketsReceived; ;
            //return ipStatV4.BytesReceived - settings.unicastPacketsReceived;

        }
        public long getIPunicastPacketSent()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.UnicastPacketsSent - settings.unicastPacketsSent;
        }
        public long getIPNonUnicastPacketReceived()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.NonUnicastPacketsReceived - settings.nonUnicastPacketsReceived;
        }
        public long getIPNonUnicastPacketSend()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.NonUnicastPacketsSent - settings.nonUnicastPacketsSent;
        }
        public long getIPOutgoingPacketsDiscarder()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.OutgoingPacketsDiscarded - settings.outgoingPacketsDiscarded;
        }
        public long getIPOutgoingPacketsWithErrors()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.OutgoingPacketsWithErrors - settings.outgoingPacketsWithErrors;
        }
        public long getIPIncomingPacketsDiscarded()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.IncomingPacketsDiscarded - settings.IncomingPacketsDiscarded;
        }
        public long getIPIncomingPacketsWithErrors()
        {
            ipStatV4 = wzc.GetIPv4Statistics();
            return ipStatV4.IncomingPacketsWithErrors - settings.longIncomingPacketsWithErrors;
        }
        public int getIPOutgingPacketsWithNoRoute()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            iPstat = IpProperties.GetIPv4GlobalStatistics();
            return iPstat.OutputPacketsWithNoRoute - settings.outputPacketsWithNoRoute;
        }

        #endregion

        #region TCP section
        public int getTCPSegmentsReceived()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = IpProperties.GetTcpIPv4Statistics();
            return TCPstat.SegmentsReceived - settings.TCPsegmentReceived;
        }

        public int getTCPSegmentsResent()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = IpProperties.GetTcpIPv4Statistics();
            return TCPstat.SegmentsResent - settings.TCPSegmentReSent;
        }

        public int getTCPSegmentsSent()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = IpProperties.GetTcpIPv4Statistics();
            return TCPstat.SegmentsSent - settings.TCPSegmentSent;
        }

        public int getTCPCurrentConnectionsNumber()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = IpProperties.GetTcpIPv4Statistics();
            return TCPstat.CurrentConnections;
        }

        public int getTCPErrorsReceived()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            TCPstat = IpProperties.GetTcpIPv4Statistics();
            return TCPstat.ErrorsReceived - settings.TCPErrorsReceived;
        }
        #endregion

        #region UDP section
        public int getUDPDatagramsReceived()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            UDPStat = IpProperties.GetUdpIPv4Statistics();
            return UDPStat.DatagramsReceived - settings.UDPDatagramsReceived;
        }

        public int getUDPDatagramsSent()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            UDPStat = IpProperties.GetUdpIPv4Statistics();
            return UDPStat.DatagramsSent - settings.UDPDatagramsSent;
        }

        public int getUDPIncomingDatagramsDiscarded()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            UDPStat = IpProperties.GetUdpIPv4Statistics();
            return UDPStat.IncomingDatagramsDiscarded - settings.UDPIncomingDatagramsDiscarded;
        }

        public int getUDPIncomingDatagramsWithErrors()
        {
            IpProperties = IPGlobalProperties.GetIPGlobalProperties();
            UDPStat = IpProperties.GetUdpIPv4Statistics();
            return UDPStat.IncomingDatagramsWithErrors - settings.UDPIncomingDatagramsWithErrors;
        }
        #endregion

        #region Radio section

        public int getSignalStrength()
        {
            return wzc.SignalStrength.Decibels;
        }

        public int getFrequency()
        {
            return wzc.RadioConfiguration.Frequency;
        }

        public uint getFrequencyHopPattern()
        {
            return wzc.RadioConfiguration.FrequencyHopPattern;
        }

        public uint getFrequencyHopSet()
        {
            return wzc.RadioConfiguration.FrequencyHopSet;
        }

        public uint getBeaconPeriod()
        {
            return wzc.RadioConfiguration.BeaconPeriod;
        }

        public uint getATIMWindow()
        {
            return wzc.RadioConfiguration.ATIMWindow;
        }

        #endregion


    }
}
