﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CFPingProject
{
    public partial class Form2 : Form
    {
        private delegate int listDelegate(String S);
        private delegate void listRefreshDelegate();
        private Ping ping;

        public Form2(Ping _ping)
        {
            ping = _ping;
            InitializeComponent();
        }

        public void upDateList(String s)
        {
            listDelegate myListBox1Delegate = new listDelegate(listBox1.Items.Add);
            listRefreshDelegate myListBox1DelegateRefresh = new listRefreshDelegate(listBox1.Refresh);
            this.Invoke(myListBox1Delegate, new object[] { s });
            this.Invoke(myListBox1DelegateRefresh,new object[]{});
            if (listBox1.Items.Count > 20)
            {
                listBox1.TopIndex = listBox1.Items.Count - 20;
            }
            
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void CloseButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void buttonSaveLog_Click(object sender, EventArgs e)
        {
            string logFile = ping.getExecutionTime().ToString().Replace(@"/", @"_").Replace(@"\", @"_").Replace(":", "-").Replace(" ", "_") + ".txt";
            System.IO.TextWriter tw = new StreamWriter("Ping" + logFile);

            tw.WriteLine("Ping Log File");
            tw.WriteLine(" ");
            tw.WriteLine("Execution Time: " + ping.getExecutionTime());
            tw.WriteLine("Destination Ip Address: " + ping.Destination.ToString());
            tw.WriteLine("Timeout: " + ping.TimeOut.ToString() + " us");
            tw.WriteLine("PacketSize: " + (ping.PacketSize-8).ToString() + "Bytes");
            tw.WriteLine("Number of Sent Packets: " + ping.NumberOfPackets.ToString());
            tw.WriteLine("Number of Lost Packets: " + ping.NumberOfLostPackets.ToString());
            tw.WriteLine("Average RTT: " + ping.AverageRTT.ToString() + " ms");
            tw.WriteLine("Max RTT: " + ping.MaxRTT.ToString() + " ms");
            tw.WriteLine("Min RTT: " + ping.MinRTT.ToString() + " ms");
            tw.WriteLine(" ");
            foreach (PingReplay pingReplay in ping.pingReplies)
            {
                
                if (pingReplay.TimeOut == false)
                {
                    tw.WriteLine(pingReplay.Identifier.ToString() + ". Reply From " + pingReplay.ReplyIP.ToString());
                    tw.WriteLine("    RTT: " + (pingReplay.Rtt).ToString()+" ms");
                }
                else
                {
                    tw.WriteLine(pingReplay.Identifier.ToString() + ". Timeout " );
                }
            }

            tw.Close();
            upDateList("  ");
            upDateList("Log Created");
        }
    }
}